/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 派单信息记录表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class TDispatchImportVo extends RowIndex implements Serializable {

	/**
	 * 员工姓名
	 */
	@Length(max = 50, message = "员工姓名 不能超过50 个字符" )
	@ExcelAttribute(name = "员工姓名", maxLength = 50, isNotEmpty = true)
	@Schema(description = "员工姓名" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名" )
	private String empName;
	/**
	 * 身份证号
	 */
	@Length(max = 20, message = "身份证号 不能超过20 个字符" )
	@ExcelAttribute(name = "身份证号", maxLength = 20, isNotEmpty = true)
	@Schema(description = "身份证号" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号" )
	private String empIdcard;
	/**
	 * 员工类型
	 */
	@Length(max = 32, message = "员工类型 不能超过32 个字符" )
	@ExcelAttribute(name = "员工类型", maxLength = 32, isDataId = true,dataType = ExcelAttributeConstants.EMP_NATRUE)
	@Schema(description = "员工类型" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工类型" )
	private String empType;
	/**
	 * 手机号码
	 */
	@Length(max = 32, message = "手机号码 不能超过32 个字符" )
	@ExcelAttribute(name = "手机号码", maxLength = 32)
	@Schema(description = "手机号码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码" )
	private String empMobile;
	/**
	 * 项目编码
	 */
	@Length(max = 32, message = "项目编码 不能超过32 个字符" )
	@ExcelAttribute(name = "项目编码", maxLength = 32, isNotEmpty = true)
	@Schema(description = "项目编码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码" )
	private String settleDomainCode;

	/**
	 * 身份证省
	 */
	@ExcelAttribute(name = "身份证省" ,isArea = true)
	@Schema(description = "身份证省" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证省" )
	private String idCardProvince;
	/**
	 * 身份证市
	 */
	@ExcelAttribute(name = "身份证市" ,isArea = true,parentField = "idCardProvince")
	@Schema(description = "身份证市" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证市" )
	private String idCardCity;
	/**
	 * 身份证县
	 */
	@ExcelAttribute(name = "身份证县",isArea = true,parentField = "idCardCity")
	@Schema(description = "身份证县" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证县" )
	private String idCardTown;

	/**
	 * 身份证所在地
	 */
	@ExcelAttribute(name = "身份证所在地")
	@Schema(description = "身份证所在地" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证所在地" )
	private String idCardAddress;

	/**
	 * 档案-省
	 */
	@ExcelAttribute(name = "档案-省" ,isArea = true, isNotEmpty = true, errorInfo = "档案-省不能为空")
	@Schema(description = "档案-省" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案-省" )
	private String fileProvince;
	/**
	 * 档案-市
	 */
	@ExcelAttribute(name = "档案-市" ,isArea = true,parentField = "fileProvince", isNotEmpty = true, errorInfo = "档案-市不能为空")
	@Schema(description = "档案-市" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案-市" )
	private String fileCity;
	/**
	 * 档案-县
	 */
	@ExcelAttribute(name = "档案-县" ,isArea = true,parentField = "fileCity", isNotEmpty = false, errorInfo = "档案-县不能为空")
	@Schema(description = "档案-县" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案-县" )
	private String fileTown;


	/**
	 * 通信地址
	 */
	@Length(max = 200, message = "通信地址不能超过200个字符" )
	@ExcelAttribute(name = "通信地址", maxLength = 200)
	@Schema(description = "通信地址" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("通信地址" )
	private String contactAddress;

	/**
	 * 就职班组
	 */
	@Length(max = 50, message = "就职班组 不能超过50 个字符" )
	@ExcelAttribute(name = "就职班组", maxLength = 50)
	@Schema(description = "就职班组" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("就职班组" )
	private String inauguralTeam;

	/**
	 * 就职岗位
	 */
	@Length(max = 30, message = "岗位 不能超过30 个字符" )
	@ExcelAttribute(name = "岗位", maxLength = 30)
	@Schema(description = "岗位" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("岗位" )
	private String post;

	/**
	 * 试用期（单位月）
	 */
	@Length(max = 4, message = "试用期 不能超过3个字符" )
	@ExcelAttribute(name = "试用期", maxLength = 4)
	@Schema(description = "试用期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("试用期" )
	private String tryPeriod;

	/**
	 * 工时制：1标准工时 2 综合工时 3不定时工时制
	 */
	@Length(max = 1, message = "工时制 不能超过50 个字符" )
	@ExcelAttribute(name = "工时制", maxLength = 50, isDataId = true,dataType = ExcelAttributeConstants.WORKING_HOURS)
	@Schema(description = "工时制：1标准工时 2 综合工时 3不定时工时制" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工时制" )
	private String workingHours;
	/**
	 * 民族
	 */
	@Length(max = 32, message = "民族 不能超过32 个字符" )
	@ExcelAttribute(name = "民族", maxLength = 32, isDataId = true,dataType = ExcelAttributeConstants.EMP_NATIONAL)
	@Schema(description = "民族" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("民族" )
	private String empNational;
	/**
	 * 户口性质
	 */
	@Length(max = 32, message = "户口性质 不能超过32 个字符" )
	@ExcelAttribute(name = "户口性质", maxLength = 32, isDataId = true,dataType = ExcelAttributeConstants.EMP_REGISTYPE)
	@Schema(description = "户口性质" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("户口性质" )
	private String empRegisType;

	/**
	 * 合同类型
	 */
	@Length(max = 32, message = "合同类型 不能超过32 个字符" )
	@ExcelAttribute(name = "合同类型", maxLength = 32, isDataId = true,isConvert = false,dataType = ExcelAttributeConstants.PERSONNEL_TYPE)
	@Schema(description = "合同类型" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同类型" )
	private String contractName;

	/**
	 * 业务细分 personnel_type_sub
	 */
	@ExcelProperty("业务细分" )
	@ExcelAttribute(name = "业务细分", maxLength = 32)
	@Schema(description = "业务细分", name = "contractName")
	private String contractSubName;
	/**
	 * 签订期限
	 * 0	已完成一定工作任务为期限
	 * 1	固定期限
	 * 2	无固定期限
	 */
	@NotBlank(message = "签订期限不能为空")
	@Length(max = 32, message = "签订期限不能超过32个字符")
	@ExcelProperty("签订期限" )
	@ExcelAttribute(name = "签订期限", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_CONTRACT_TYPE)
	@Schema(description = "签订期限", name = "contractType")
	private String contractType;

	/**
	 * 合同起始时间
	 */
	@ExcelAttribute(name = "合同起始时间", isDate = true)
	@Schema(description = "合同起始时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同起始时间" )
	private Date contractStart;
	/**
	 * 合同到期时间
	 */
	@ExcelAttribute(name = "合同到期时间", isDate = true)
	@Schema(description = "合同到期时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同到期时间" )
	private Date contractEnd;
	/**
	 * 合同期限
	 */
	@ExcelAttribute(name = "合同期限")
	@Schema(description = "合同期限" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同期限" )
	private String contractTerm;

	/**
	 * 学历名称
	 */
	@ExcelAttribute(name = "学历",isNotEmpty = false)
	@Schema(description = "学历：派增只做记录" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="学历")
	private String educationName;

	/**
	 * 学校
	 */
	@ExcelAttribute(name = "学校",isNotEmpty = false,maxLength = 50)
	@Length(max = 50, message = "学校不能超过50个字符")
	@Schema(description = "学校：派增只做记录" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="学校")
	private String schoolName;

	/**
	 * 毕业时间
	 */
	@ExcelAttribute(name = "毕业时间", isDate = true)
	@Schema(description = "毕业时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("毕业时间" )
	private Date graduationTime;

	/**
	 * 专业
	 */
	@ExcelAttribute(name = "专业",isNotEmpty = false,maxLength = 50)
	@Length(max = 50, message = "学校不能超过50个字符")
	@Schema(description = "专业：派增只做记录" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="专业")
	private String major;

	/**
	 * 首次至缴纳地时间
	 */
	@ExcelAttribute(name = "首次至缴纳地时间",isNotEmpty = false,isDate = true)
	@Length(max = 50, message = "学校不能超过50个字符")
	@Schema(description = "首次至缴纳地时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="首次至缴纳地时间")
	private Date firstPayTime;

	/**
	 * 备案基数
	 */
	@Length(max = 255, message = "备案基数 不能超过255 个字符" )
	@ExcelAttribute(name = "备案基数", isFloat = true,max = "999999999.99")
	@Schema(description = "备案基数：购买社保时必填" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备案基数" )
	private BigDecimal recordBase;

	/**
	 * 社保户
	 */
	@Length(max = 50, message = "社保户 不能超过50个字符" )
	@ExcelAttribute(name = "社保户", maxLength = 50)
	@Schema(description = "社保户" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户" )
	private String socialHousehold;

	/**
	 * 养老起缴日期
	 */
	@ExcelAttribute(name = "养老起缴日期", isDate = true)
	@Schema(description = "养老起缴日期：购买社保时必填" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老起缴日期" )
	private Date pensionStart;
	/**
	 * 医疗起缴日期
	 */
	@ExcelAttribute(name = "医疗起缴日期", isDate = true)
	@Schema(description = "医疗起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗起缴日期" )
	private Date medicalStart;
	/**
	 * 失业起缴日期
	 */
	@ExcelAttribute(name = "失业起缴日期", isDate = true)
	@Schema(description = "失业起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业起缴日期" )
	private Date unemployStart;
	/**
	 * 工伤起缴日期
	 */
	@ExcelAttribute(name = "工伤起缴日期", isDate = true)
	@Schema(description = "工伤起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤起缴日期" )
	private Date workInjuryStart;
	/**
	 * 生育起缴日期
	 */
	@ExcelAttribute(name = "生育起缴日期", isDate = true)
	@Schema(description = "生育起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育起缴日期" )
	private Date birthStart;
	/**
	 * 大病起缴日期
	 */
	@ExcelAttribute(name = "大病起缴日期", isDate = true)
	@Schema(description = "大病起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病起缴日期" )
	private Date bigailmentStart;
	/**
	 * 缴纳类型（0最低、1自定义、2最高）
	 */
	@Length(max = 1, message = "缴纳类型 不能超过1 个字符" )
	@ExcelAttribute(name = "缴纳类型", isDataId = true, readConverterExp = "0=最低,1=自定义,2=最高")
	@Schema(description = "缴纳类型:（0最低、1自定义、2最高）" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳类型" )
	private String paymentType;

	/**
	 * 养老基数
	 */
	@ExcelAttribute(name = "养老基数",  isFloat = true,max = "999999999.99" )
	@Schema(description = "养老基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老基数" )
	private BigDecimal pensionCardinal;
	/**
	 * 医疗基数
	 */
	@ExcelAttribute(name = "医疗基数",  isFloat = true,max = "999999999.99" )
	@Schema(description = "医疗基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗基数" )
	private BigDecimal medicalCardinal;
	/**
	 * 失业基数
	 */
	@ExcelAttribute(name = "失业基数",  isFloat = true,max = "999999999.99" )
	@Schema(description = "失业基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业基数" )
	private BigDecimal unemploymentCardinal;

	/**
	 * 工伤基数
	 */
	@ExcelAttribute(name = "工伤基数",  isFloat = true,max = "999999999.99" )
	@Schema(description = "工伤基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤基数" )
	private BigDecimal workInjuryCardinal;
	/**
	 * 生育基数
	 */
	@ExcelAttribute(name = "生育基数",  isFloat = true,max = "999999999.99" )
	@Schema(description = "生育基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育基数" )
	private BigDecimal birthCardinal;

	/**
	 * 大病基数
	 */
	@ExcelAttribute(name = "大病基数" ,  isFloat = true,max = "999999999.99" )
	@Schema(description = "大病基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病基数" )
	private BigDecimal bigailmentCardinal;

	/**
	 * 公积金户
	 */
	@Length(max = 50, message = "公积金户 不能超过50 个字符" )
	@ExcelAttribute(name = "公积金户", maxLength = 50)
	@Schema(description = "公积金户" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户" )
	private String providentHousehold;

	/**
	 * 公积金起缴日期
	 */
	@ExcelAttribute(name = "公积金起缴日期", isDate = true)
	@Schema(description = "公积金起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金起缴日期" )
	private Date providentStart;

	/**
	 * 公积金基数
	 */
	@ExcelAttribute(name = "公积金基数",  isFloat = true,max = "999999999.99" )
	@Schema(description = "公积金基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金基数" )
	private BigDecimal providentCardinal;

	/**
	 * 单位公积金比例（原‘公积金比例’）
	 */
	@ExcelAttribute(name = "单位公积金缴纳比例" )
	@Schema(description = "单位公积金缴纳比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金缴纳比例" )
	private BigDecimal providentPer;


	/**
	 * 个人公积金缴纳比例
	 */
	@ExcelAttribute(name = "个人公积金缴纳比例" )
	@Schema(description = "个人公积金缴纳比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金缴纳比例" )
	private BigDecimal personalProvidentPer;

	/**
	 * 公积金单位个人比例是否一致 0 是 1 否
	 */
	@ExcelAttribute(name = "公积金单位个人比例是否一致" ,isDataId = true,readConverterExp = "0=是,1=否")
	@Schema(description = "公积金单位个人比例是否一致" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金单位个人比例是否一致" )
	private String perFlag  ;


	/**
	 * 委托备注
	 */
	@Length(max = 100, message = "委托备注 不能超过100 个字符" )
	@ExcelAttribute(name = "委托备注", maxLength = 100)
	@Schema(description = "委托备注" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("委托备注" )
	private String trustRemark;

	/**
	 * 项目ID
	 */
	@Schema(description = "项目ID")
	@ExcelIgnore
	private String settleDomainId;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	@ExcelIgnore
	private String departName;

	/**
	 * 所属客户
	 */
	@Schema(description = "所属客户")
	@ExcelIgnore
	private String customerId;

	/**
	 * 客户名称
	 */
	@Schema(description = "客户名称")
	@ExcelIgnore
	private String customerName;

	/**
	 * 客户编码
	 */
	@Schema(description = "客户编码")
	@ExcelIgnore
	private String customerCode;

	/**
	 * 派单ID （实时更新）
	 */
	@ExcelIgnore
	@Schema(description = "派单ID" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派单ID" )
	private String dispatchId;


	/**
	 * 订单ID
	 */
	private String orderId;

}
