/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialSoldierShenBaoTask;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TSocialSoldierShenBaoTaskMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialSoldierShenBaoTaskService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 社保自动化审核提交后的审核结果查询记录表
 *
 * @author hgw
 * @date 2024-05-23 17:40:37
 */
@Log4j2
@Service
public class TSocialSoldierShenBaoTaskServiceImpl extends ServiceImpl<TSocialSoldierShenBaoTaskMapper, TSocialSoldierShenBaoTask> implements TSocialSoldierShenBaoTaskService {
	/**
	 * 社保自动化审核提交后的审核结果查询记录表简单分页查询
	 *
	 * @param tSocialSoldierShenBaoTask 社保自动化审核提交后的审核结果查询记录表
	 * @return
	 */
	@Override
	public List<TSocialSoldierShenBaoTask> getTSocialSoldierShenBaoTaskList(TSocialSoldierShenBaoTask tSocialSoldierShenBaoTask) {
		return baseMapper.getTSocialSoldierShenBaoTaskList(tSocialSoldierShenBaoTask);
	}

	@Override
	public List<TSocialSoldierShenBaoTask> getTSocialSoldierTaskListByRe() {
		return baseMapper.getTSocialSoldierTaskListByRe();
	}
	/**
	 * 获取任务id
	 * @return
	 */
	@Override
	public TSocialSoldierShenBaoTask getSoldierTaskAddIdByType(String type) {
		return baseMapper.getSoldierTaskAddIdByType(type);
	}

	@Override
	public void deleteByPayment() {
		baseMapper.deleteByPayment();
	}
	@Override
	public void deleteByRePayment() {
		baseMapper.deleteByRePayment();
	}

}
