/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDataAuthMenuRel;
import com.yifu.cloud.plus.v1.yifu.admin.mapper.SysDataAuthMenuRelMapper;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysDataAuthMenuRelService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Description: 数据权限配置相关服务实现
 * @Author: hgw
 * @Date: 2022/6/8 17:20
 **/
@Service
@RequiredArgsConstructor
public class SysDataAuthMenuRelServiceImpl extends ServiceImpl<SysDataAuthMenuRelMapper, SysDataAuthMenuRel> implements SysDataAuthMenuRelService {

	// 清空
	@Override
	public int deleteAuthMenuRelByAuthId(String mainId) {
		return baseMapper.deleteAuthMenuRelByAuthId(mainId);
	}

	/**
	 * @param mainId 权限主表id
	 * @Description: 根据权限主表id查询
	 * @Author: hgw
	 * @Date: 2022/6/9 14:31
	 **/
	@Override
	public List<SysDataAuthMenuRel> getByMainId(String mainId) {
		return baseMapper.getByMainId(mainId);
	}
}
