/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * 法大大印章授权表
 *
 * @author huyc
 * @date 2022-06-28 16:24:12
 */
@Data
@TableName("fdd_seal_person_auth")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "法大大印章授权表")
public class FddSealPersonAuth extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description ="主键")
	private String id;

	/**
	 * 法大大印章ID
	 */
	@Schema(description ="法大大印章ID")
	private String sealId;

	/**
	 * 员工id
	 */
	@Schema(description ="员工id")
	private String fddPersonAccountId;

	/**
	 * 授权状态 0:未授权 1已授权
	 */
	@Schema(description ="授权状态 0:未授权 1已授权")
	private String status;

	/**
	 * 创建者
	 */
	@Schema(description ="创建者")
	private String createBy;

	/**
	 * 更新人
	 */
	@Schema(description ="更新人")
	private String updateBy;

	/**
	 * 创建时间
	 */
	@Schema(description ="创建时间")
	private LocalDateTime createTime;

	/**
	 * 更新时间
	 */
	@Schema(description ="更新时间")
	private LocalDateTime updateTime;

	/**
	 * 创建人姓名
	 */
	@Schema(description ="创建人姓名")
	private String createName;


}
