/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 预入职导入的表格内容
 *
 * @author hgw
 * @date 2024-10-12 15:12:02
 */
@Data
public class PreUploadEmpImportVo implements Serializable {

	// （字典值，0外包1派遣2代理）
	@ExcelAttribute(name = "员工类型", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE, maxLength = 4)
	private String empNatrue;
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	private String empName;
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, maxLength = 20)
	private String empIdcard;
	@ExcelAttribute(name = "身份证开始日期", isNotEmpty = true, isDate = true)
	private String validityStart;
	@ExcelAttribute(name = "身份证截止日期", isNotEmpty = true, isDate = true, pattern = "validityStart")
	private String validityEnd;
	@ExcelAttribute(name = "婚姻状况", isDataId = true, dataType = ExcelAttributeConstants.EMP_MARRIED, isNotEmpty = true, maxLength = 32)
	private String empMarriStatus;
	@ExcelAttribute(name = "民族", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATIONAL, isNotEmpty = true, maxLength = 32)
	private String empNational;
	@ExcelAttribute(name = "政治面貌", isDataId = true, dataType = ExcelAttributeConstants.EMP_POLITICAL, isNotEmpty = true, maxLength = 32)
	private String politicalStatus;
	@ExcelAttribute(name = "手机号码", isPhone = true, isNotEmpty = true, maxLength = 32)
	private String empPhone;
	@ExcelAttribute(name = "邮箱", maxLength = 50)
	private String empEmail;
	// 区域ID
	@ExcelAttribute(name = "户籍所在地-省", isArea = true)
	private String idProvince;
	@ExcelAttribute(name = "户籍所在地-市", isArea = true, parentField = "idProvince")
	private String idCity;
	@ExcelAttribute(name = "户籍所在地-区/县", isArea = true, parentField = "idCity")
	private String idTown;
	@ExcelAttribute(name = "户口性质", isDataId = true, dataType = ExcelAttributeConstants.EMP_REGISTYPE, isNotEmpty = true, maxLength = 32)
	private String empRegisType;
	@ExcelAttribute(name = "档案所在地-省", isNotEmpty = true, isArea = true)
	private String fileProvince;
	@ExcelAttribute(name = "档案所在地-市", isNotEmpty = true, isArea = true, parentField = "fileProvince")
	private String fileCity;
	@ExcelAttribute(name = "档案所在地-区/县", isArea = true, parentField = "fileCity")
	private String fileTown;
	@ExcelAttribute(name = "通信地址-省", isNotEmpty = true, isArea = true)
	private String contactProvince;
	@ExcelAttribute(name = "通信地址-市", isNotEmpty = true, isArea = true, parentField = "contactProvince")
	private String contactCity;
	@ExcelAttribute(name = "通信地址-区/县", isNotEmpty = true, isArea = true, parentField = "contactCity")
	private String contactTown;
	@ExcelAttribute(name = "通信地址-详细地址", isNotEmpty = true, maxLength = 200)
	private String contactAddress;

	// 紧急联系人
	// private TPreEmpContactInfo tpreEmpContactInfo
	// 紧急联系人姓名	与本人关系	联系地址-省	联系地址-市	联系地址-区/县	联系地址-详细地址	手机号码（紧急联系人）
	@ExcelAttribute(name = "紧急联系人姓名", isNotEmpty = true, errorInfo = "紧急联系人姓名不能为空", maxLength = 20)
	private String contactEmpName;
	@ExcelAttribute(name = "紧急联系人与本人关系", isNotEmpty = true, errorInfo = "与本人关系不能为空", maxLength = 50)
	private String relationType;
	@ExcelAttribute(name = "联系地址-省", isNotEmpty = true, isArea = true)
	private String relationProvince;
	@ExcelAttribute(name = "联系地址-市", isNotEmpty = true, isArea = true, parentField = "relationProvince")
	private String relationCity;
	@ExcelAttribute(name = "联系地址-区/县", isNotEmpty = true, isArea = true, parentField = "relationCity")
	private String relationTown;
	@ExcelAttribute(name = "联系地址-详细地址", isNotEmpty = true, errorInfo = "联系地址-街道、详情不能为空", maxLength = 200)
	private String address;
	@ExcelAttribute(name = "手机号码（紧急联系人）", isPhone = true, isNotEmpty = true, errorInfo = "手机号码（紧急联系人）不能为空", maxLength = 20)
	private String tel;

	// 预入职-员工学历信息表
	// private TPreEmpEducation tpreEmpEducation
	// 学历	学校	专业	教育开始时间	教育结束时间	是否大专及以上	最高学历
	@ExcelAttribute(name = "学历", isDataId = true, dataType = ExcelAttributeConstants.EDUCATION, isNotEmpty = true, maxLength = 32)
	private String educationName;
	@ExcelAttribute(name = "学校", maxLength = 50)
	private String school;
	@ExcelAttribute(name = "专业", maxLength = 50)
	private String major;
	@ExcelAttribute(name = "教育开始时间", isDate = true)
	private String entryDate;
	@ExcelAttribute(name = "教育结束时间", isDate = true, pattern = "entryDate")
	private String gradutionDate;

	// 是否为首份工作	工作单位	工作岗位	开始工作日期	结束工作日期
	// 预入职-员工工作履历信息表
	// private List<TPreEmpWorkRecording> tpreEmpWorkRecordingList
	// 是否为首份工作 0是/1否
	@ExcelAttribute(name = "是否为首份工作", isMark = true, isDataId = true, readConverterExp = "0=是,1=否", isNotEmpty = true, maxLength = 1)
	private String firstWorkFlag;
	@ExcelAttribute(name = "工作单位", errorInfo = "工作单位不能为空", maxLength = 100)
	private String workUnit;
	@ExcelAttribute(name = "工作岗位", maxLength = 100)
	private String workJob;
	@ExcelAttribute(name = "开始工作日期", isMark = true, errorInfo = "开始工作日期不能为空", isDate = true)
	private String startDate;
	@ExcelAttribute(name = "结束工作日期", isMark = true, isDate = true, pattern = "startDate")
	private String endDate;

	// 成员姓名	与本人关系	手机号码（家庭成员）
	// 预入职-员工家庭信息表
	// private List<TPreEmpFamily> tpreEmpFamilyList
	@ExcelAttribute(name = "家庭成员成员姓名", maxLength = 20)
	private String familyName;
	@ExcelAttribute(name = "家庭成员与本人关系", isMark = true,isDataId = true,dataType = ExcelAttributeConstants.FAMILY_RELATION, maxLength = 32)
	private String relationshipSelf;
	@ExcelAttribute(name = "手机号码（家庭成员）", isMark = true, isPhone = true, maxLength = 32)
	private String contractTel;

	// 是否有职业资格证书	申报年度	职业资格名称
	// 预入职-员工职业资格信息表
	// private List<TPreEmpProfessionalQualification> tpreEmpProfessionalQualificationList
	@ExcelAttribute(name = "是否有职业资格证书", isMark = true, isNotEmpty = true, isDataId = true, readConverterExp = "0=是,1=否")
	private String haveQualification;
	@ExcelAttribute(name = "申报年度", isMark = true, isDate = true, dateFormat = "yyyy", maxLength = 32)
	private String declareYear;
	@ExcelAttribute(name = "职业资格名称", isMark = true, isDataId = true, dataType = ExcelAttributeConstants.QUALIFICATION_TYPE, errorInfo = "职业资格名称不能为空", maxLength = 32)
	private String qualificationType;

	// 是否曾被认定为工伤	是否有职业病	职业病名称	是否有传染性疾病	传染病名称	是否被劳动能力鉴定委员会鉴定为具有伤残等级	伤残病名称	伤残等级
	// 是否从事过井下、高空、高温、特别繁重体力劳动以及有毒有害工种	
	// 预入职-员工伤残信息表
	// private TPreEmpDisabilityInfo tpreEmpDisabilityInfo
	// 是否工伤标识0是/1否
	@ExcelAttribute(name = "是否曾被认定为工伤", isDataId = true, readConverterExp = "0=是,1=否", isNotEmpty = true, maxLength = 1)
	private String injuryIdentification;
	// 是否职业病 0是/1否
	@ExcelAttribute(name = "是否有职业病", isDataId = true, readConverterExp = "0=是,1=否", isNotEmpty = true, maxLength = 1)
	private String occupationalDiseaseFlag;
	@ExcelAttribute(name = "职业病名称", maxLength = 50)
	private String occupationalDisease;
	// 是否传染病病 0是/1否
	@ExcelAttribute(name = "是否有传染性疾病", isDataId = true, readConverterExp = "0=是,1=否", isNotEmpty = true, maxLength = 1)
	private String infectiousDiseaseFlag;
	@ExcelAttribute(name = "传染病名称", maxLength = 50)
	private String infectiousName;
	// 是否持有残疾人证明 0是/1否
	@ExcelAttribute(name = "是否被劳动能力鉴定委员会鉴定为具有伤残等级", isDataId = true, readConverterExp = "0=是,1=否", isNotEmpty = true, maxLength = 1)
	private String disabilityFlag;
	@ExcelAttribute(name = "伤残病名称", maxLength = 50)
	private String disabilityName;
	@ExcelAttribute(name = "伤残等级",isDataId = true, dataType = ExcelAttributeConstants.DISABILITY_GRADE, maxLength = 32)
	private String disabilityLevel;
	// 是否从事过井下、高空、高温、特别繁重体力劳动以及有毒有害工种 0是/1否
	@ExcelAttribute(name = "是否从事过井下、高空、高温、特别繁重体力劳动以及有毒有害工种", isDataId = true, readConverterExp = "0=是,1=否", isNotEmpty = true, maxLength = 1)
	private String otherFlag;
	// 是否曾经或正在追究与承担过刑事责任
	// 预入职-员工不良记录表
	// private TPreEmpBadRecord tpreEmpBadRecord
	@ExcelAttribute(name = "是否曾经或正在追究与承担过刑事责任", isDataId = true, readConverterExp = "0=是,1=否", isNotEmpty = true, maxLength = 200)
	private String remark;

	// 银行卡号	开户总行	开户省	开户市	开户支行	计税月份
	@ExcelAttribute(name = "银行卡号", maxLength = 50)
	private String bankNo;
	@ExcelAttribute(name = "开户行总行", maxLength = 50)
	private String bankName;
	@ExcelAttribute(name = "开户省", isArea = true)
	private String bankProvince;
	@ExcelAttribute(name = "开户市", isArea = true, parentField = "bankProvince")
	private String bankCity;
	@ExcelAttribute(name = "开户支行", maxLength = 50)
	private String bankSubName;
	@ExcelAttribute(name = "计税月份", isDate = true, dateFormat = "yyyyMM", maxLength = 6)
	private String taxMonth;

	// 字典值起始
	@ExcelAttribute(name = "员工类型")
	private String empNatrueValue;
	@ExcelAttribute(name = "婚姻状况")
	private String empMarriStatusValue;
	@ExcelAttribute(name = "民族")
	private String empNationalValue;
	@ExcelAttribute(name = "政治面貌")
	private String politicalStatusValue;
	@ExcelAttribute(name = "户籍所在地-省")
	private String idProvinceValue;
	@ExcelAttribute(name = "户籍所在地-市")
	private String idCityValue;
	@ExcelAttribute(name = "户籍所在地-县")
	private String idTownValue;
	@ExcelAttribute(name = "户口性质")
	private String empRegisTypeValue;
	@ExcelAttribute(name = "档案所在地-省")
	private String fileProvinceValue;
	@ExcelAttribute(name = "档案所在地-市")
	private String fileCityValue;
	@ExcelAttribute(name = "档案所在地-县")
	private String fileTownValue;
	@ExcelAttribute(name = "通信地址-省")
	private String contactProvinceValue;
	@ExcelAttribute(name = "通信地址-市")
	private String contactCityValue;
	@ExcelAttribute(name = "通信地址-县")
	private String contactTownValue;
	// 紧急联系人
	@ExcelAttribute(name = "联系地址-省")
	private String relationProvinceValue;
	@ExcelAttribute(name = "联系地址-市")
	private String relationCityValue;
	@ExcelAttribute(name = "联系地址-县")
	private String relationTownValue;
	@ExcelAttribute(name = "教育开始时间")
	private Date entryDateValue;
	@ExcelAttribute(name = "教育结束时间")
	private Date gradutionDateValue;
	@ExcelAttribute(name = "开始工作日期")
	private Date startDateValue;
	@ExcelAttribute(name = "结束工作日期")
	private Date endDateValue;
	// 预入职-员工学历信息表
	@ExcelAttribute(name = "学历")
	private String educationNameValue;
	// 预入职-员工工作履历信息表
	@ExcelAttribute(name = "是否为首份工作")
	private String firstWorkFlagValue;
	@ExcelAttribute(name = "与本人关系")
	private String relationshipSelfValue;
	// 预入职-员工职业资格信息表
	@ExcelAttribute(name = "是否有职业资格证书")
	private String haveQualificationValue;
	@ExcelAttribute(name = "申报年度")
	private String declareYearValue;
	@ExcelAttribute(name = "职业资格名称")
	private String qualificationTypeValue;
	// 预入职-员工伤残信息表
	@ExcelAttribute(name = "是否曾被认定为工伤")
	private String injuryIdentificationValue;
	@ExcelAttribute(name = "是否有职业病")
	private String occupationalDiseaseFlagValue;
	@ExcelAttribute(name = "是否有传染性疾病")
	private String infectiousDiseaseFlagValue;
	@ExcelAttribute(name = "是否被劳动能力鉴定委员会鉴定为具有伤残等级")
	private String disabilityFlagValue;
	@ExcelAttribute(name = "伤残等级")
	private String disabilityLevelValue;
	@ExcelAttribute(name = "是否从事过井下、高空、高温、特别繁重体力劳动以及有毒有害工种")
	private String otherFlagValue;
	// 银行卡号	开户总行	开户省	开户市	开户支行	计税月份
	@ExcelAttribute(name = "开户省")
	private String bankProvinceValue;
	@ExcelAttribute(name = "开户市")
	private String bankCityValue;
	@ExcelAttribute(name = "计税月份")
	private String taxMonthValue;

	@ExcelAttribute(name = "身份证开始日期")
	private Date validityStartValue;
	@ExcelAttribute(name = "身份证截止日期")
	private Date validityEndValue;
	// 字典值结束

	// 是否主信息，未false，则仅更新附属信息
	@TableField(exist = false)
	private Boolean isMain;


	@TableField(exist = false)
	private int lineNum;

	@TableField(exist = false)
	private String errorInfo;

}
