/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 社保户批量新增
 *
 * @author huych
 * @date 2024-12-5 11:38:05
 */
@Data
public class TSocialHouseholdUpdateVo extends RowIndex implements Serializable {
	/**
	 * 员工姓名
	 */
	@Length(max = 50, message = "户名不能超过50个字符")
	@ExcelAttribute(name = "户名", maxLength = 50,isNotEmpty = true)
	@Schema(description = "户名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "户名")
	private String name;

	/**
	 * 缴纳地所在省
	 */
	@Length(max = 32, message = "不能超过32个字符")
	@ExcelAttribute(name = "缴纳地所在省",  maxLength = 32, isArea = true, parentField = "")
	@Schema(description = "缴纳地所在省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "缴纳地所在省")
	private String province;

	/**
	 * 缴纳地所在市
	 */
	@Length(max = 32, message = "不能超过32个字符")
	@ExcelAttribute(name = "缴纳地所在市",  maxLength = 32, isArea = true, parentField = "province")
	@Schema(description = "缴纳地所在市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "缴纳地所在市")
	private String city;

	/**
	 * 缴纳地所在县
	 */
	@Length(max = 32, message = "不能超过32个字符")
	@ExcelAttribute(name = "缴纳地所在县",  maxLength = 32, isArea = true, parentField = "city")
	@Schema(description = "缴纳地所在县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "缴纳地所在县")
	private String town;

	/**
	 * 所属机构
	 */
	@ExcelAttribute(name = "所属机构", maxLength = 50)
	@Schema(description ="所属机构")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所属机构")
	private String organName;

	/**
	 * 审核人
	 */
	@ExcelAttribute(name = "审核人", maxLength = 50)
	@Schema(description ="审核人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核人")
	private String auditUserName;

	/**
	 * 办理人
	 */
	@ExcelAttribute(name = "办理人", maxLength = 50)
	@Schema(description ="办理人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("办理人")
	private String handleUserName;

	/**
	 * 手机号
	 */
	@ExcelAttribute(name = "手机号", maxLength = 20,isInteger = true)
	@Schema(description ="手机号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号")
	private String phone;

	/**
	 * 类型 0 独立户 1 自由户
	 */
	@ExcelAttribute(name = "户类型", maxLength = 3)
	@Schema(description ="户类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("户类型")
	private String houseType;

	/**
	 * 单位编号
	 */
	@ExcelAttribute(name = "社保-单位编号", maxLength = 50 )
	@Length(max = 50, message = "社保-不能超过50个字符")
	@Schema(description ="社保-单位编号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保-单位编号")
	private String customerNo;

	/**
	 * 单位统一信用代码
	 */
	@ExcelAttribute(name = "单位统一信用代码", maxLength = 50 )
	@Length(max = 50, message = "单位统一信用代码不能超过50个字符")
	@Schema(description ="单位统一信用代码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位统一信用代码")
	private String unitCreditCode;

	/**
	 * 医保单位编号
	 */
	@ExcelAttribute(name = "医保-单位编号", maxLength = 50 )
	@Length(max = 50, message = "医保-单位编号不能超过50个字符")
	@Schema(description ="医保-单位编号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保-单位编号")
	private String customerNoYsd;

	/**
	 * 社保-登录账户
	 */
	@ExcelAttribute(name = "社保-登录账户", maxLength = 50 )
	@Length(max = 50, message = "社保-登录账户不能超过50个字符")
	@Schema(description ="社保-登录账户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保-登录账户")
	private String socialAccount;

	/**
	 * 社保-登录密码
	 */
	@ExcelAttribute(name = "社保-登录密码", maxLength = 50 )
	@Length(max = 50, message = "社保-登录密码不能超过50个字符")
	@Schema(description ="社保-登录密码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保-登录密码")
	private String socialPassword;

	/**
	 * 医保-登录账户
	 */
	@ExcelAttribute(name = "医保-登录账户", maxLength = 50 )
	@Length(max = 50, message = "医保-登录账户不能超过50个字符")
	@Schema(description ="医保-登录账户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保-登录账户")
	private String mediclAccount;

	/**
	 * 医保-登录密码
	 */
	@ExcelAttribute(name = "医保-登录密码", maxLength = 50 )
	@Length(max = 50, message = "医保-登录密码不能超过50个字符")
	@Schema(description ="医保-登录密码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保-登录密码")
	private String mediclPassword;

	/**
	 * 是否自动生成解除劳动合同书 0否1是（是的话，走单个推送，因为税友的减员接口没有批量附件的字段）
	 */
	@ExcelAttribute(name = "是否需要《解除劳动合同证明书》",errorInfo = "是否需要《解除劳动合同证明书》不能为空")
	@Schema(description ="是否需要《解除劳动合同证明书》")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否需要《解除劳动合同证明书》")
	private String isAutoLeaveDoc;
	/**
	 * 自动化配置状态 0 是 1 否
	 */
	@ExcelAttribute(name = "社保是否自动办理", maxLength = 1,isNotEmpty = true,errorInfo = "社保是否自动办理不能为空")
	@Schema(description ="社保是否自动办理")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保是否自动办理")
	private String autoStatus;


	/**
	 * 医保自动化（自动化配置状态） 0 启用 1 禁用  -MVP1.7.15新增医保自动化
	 */
	@ExcelAttribute(name = "医保是否自动办理",isNotEmpty = true, maxLength = 1 ,errorInfo = "医保是否自动办理不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保是否自动办理")
	@Schema(description ="医保是否自动办理")
	private String autoStatusYsd;

	/**
	 * 社保推送类型（是否单个接口） 0否1是（税友接口走单个还是批量，审核是否立即推送税友） MVP1.7.15 调整为社保推送类型 0批量 1单个
	 */
	@ExcelAttribute(name = "社保推送类型" ,errorInfo = "社保推送类型不能为空")
	@Schema(description ="社保推送类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保推送类型")
	private String isSingle;

	/**
	 * 医保推送类型 0否1是 MVP1.7.15 新增医保推送类型 0批量 1单个
	 */
	@ExcelAttribute(name = "医保推送类型" ,errorInfo = "医保推送类型不能为空")
	@Schema(description ="医保推送类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保推送类型")
	private String isSingleYsd;

	/**
	 * 社保是否自动生成花名册 0否1是
	 */
	@ExcelAttribute(name = "社保是否自动生成花名册"  ,errorInfo = "社保是否自动生成花名册不能为空")
	@Schema(description ="社保是否自动生成花名册 0否1是")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保是否自动生成花名册")
	private String rosterAutoFlagYgs;

	/**
	 * 医保是否自动生成花名册 0否1是
	 */
	@ExcelAttribute(name = "医保是否自动生成花名册"  ,errorInfo = "医保是否自动生成花名册不能为空")
	@Schema(description ="医保是否自动生成花名册 0否1是")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保是否自动生成花名册")
	private String rosterAutoFlagYsd;

	/**
	 * 社保仅补缴生成材料 0否1是
	 */
	@ExcelAttribute(name = "社保仅补缴生成材料"  ,errorInfo = "社保仅补缴生成材料不能为空")
	@Schema(description ="社保仅补缴生成材料 0否1是")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保仅补缴生成材料")
	private String dataFlagYgs;

	/**
	 * 医保仅补缴生成材料 0否1是
	 */
	@ExcelAttribute(name = "医保仅补缴生成材料"  ,errorInfo = "医保仅补缴生成材料不能为空")
	@Schema(description ="医保仅补缴生成材料 0否1是")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保仅补缴生成材料")
	private String dataFlagYsd;

}
