/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeePreLog;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmployeePreLogService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeePreLogSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 入职确认信息变更日志表
 *
 * @author hgw
 * @date 2025-04-07 15:35:05
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/temployeeprelog")
@Tag(name = "入职确认信息变更日志表管理")
public class TEmployeePreLogController {

	private final TEmployeePreLogService tEmployeePreLogService;

	/**
	 * 简单分页查询
	 *
	 * @param page            分页对象
	 * @param tEmployeePreLog 入职确认信息变更日志表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TEmployeePreLog>> getTEmployeePreLogPage(Page<TEmployeePreLog> page, TEmployeePreLogSearchVo tEmployeePreLog) {
		return new R<>(tEmployeePreLogService.getTEmployeePreLogPage(page, tEmployeePreLog));
	}

	/**
	 * 不分页查询
	 *
	 * @param tEmployeePreLog 入职确认信息变更日志表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	public R<List<TEmployeePreLog>> getTEmployeePreLogNoPage(@RequestBody TEmployeePreLogSearchVo tEmployeePreLog) {
		return R.ok(tEmployeePreLogService.noPageDiy(tEmployeePreLog));
	}

	/**
	 * 通过id查询入职确认信息变更日志表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('archives_temployeeprelog_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_temployeeprelog_get')")
	public R<TEmployeePreLog> getById(@PathVariable("id") String id) {
		return R.ok(tEmployeePreLogService.getById(id));
	}

}
