/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TFascTemplateDetail;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TFascTemplateDetailExportVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TFascTemplateDetailSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 法大大专业版模板映射表
 *
 * @author hgw
 * @date 2025-09-30 16:29:28
 */
@Mapper
public interface TFascTemplateDetailMapper extends BaseMapper<TFascTemplateDetail> {
    /**
     * 法大大专业版模板映射表简单分页查询
     * @param tFascTemplateDetail 法大大专业版模板映射表
     * @return
     */
    IPage<TFascTemplateDetail> getTFascTemplateDetailPage(Page<TFascTemplateDetail> page, @Param("tFascTemplateDetail") TFascTemplateDetail tFascTemplateDetail);

    List<TFascTemplateDetail> getTDetailListByFieldType(@Param("fadadaTemplateId") String fadadaTemplateId);

    List<TFascTemplateDetail> getTFascTemplateDetailList(@Param("tFascTemplateDetail") TFascTemplateDetail tFascTemplateDetail);

    List<TFascTemplateDetailExportVo> getTFascTemplateDetailExport(@Param("tFascTemplateDetail") TFascTemplateDetailSearchVo tFascTemplateDetail, @Param("idList") List<String> idList);

    Long getTFascTemplateDetailExportCount(@Param("tFascTemplateDetail") TFascTemplateDetail tFascTemplateDetail, @Param("idList") List<String> idList);

	// 查找有hr字段的明细，用来清空前加日志
	List<TFascTemplateDetail> getDetailByHaveHrField(@Param("templateId") String templateId);

    void initDetailHrField(@Param("templateId") String templateId);
}
