package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsurancePolicy;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.*;

import java.io.InputStream;
import java.util.List;

/**
 * @author licancan
 * @description 针对表【t_insurance_policy(保单号对应起止时间表)】的数据库操作Service
 * @date 2022-12-07 16:40:16
 */
public interface TInsurancePolicyService extends IService<TInsurancePolicy> {

	/**
	 * 保单号对应起止保时间分页查询
	 *
	 * @author licancan
	 * @param page 分页对象
	 * @param param 查询参数
	 * @return {@link IPage<TInsurancePolicy>}
	 */
	IPage<TInsurancePolicy> pageDiy(Page page, InsurancePolicyListParam param);

	/**
	 * 保单号对应起止保时间列表（不分页）
	 *
	 * @author licancan
	 * @param param
	 * @return {@link List<TInsurancePolicy>}
	 */
	List<TInsurancePolicy> getInsurancePolicyList(InsurancePolicyListParam param);

	/**
	 * 通过id查询详情
	 *
	 * @author licancan
	 * @param id
	 * @return {@link R<TInsurancePolicyDetailVO>}
	 */
	R<TInsurancePolicyDetailVO> getDetailById(String id);

	/**
	 * 新增
	 *
	 * @author licancan
	 * @param policy
	 * @return {@link R}
	 */
	R saveTInsurancePolicy(TInsurancePolicy policy);

	/**
	 * 修改保单号对应起止保时间
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R}
	 */
    R updateInsurancePolicy(InsurancePolicyListEditParam param);

	/**
	 * 删除保单号对应起止保时间
	 *
	 * @author licancan
	 * @param id 主键
	 * @return {@link R}
	 */
	R deleteInsurancePolicy(String id);

    R<List<ErrorMessage>> importInsurancePolicy(InputStream inputStream);

	Page<PolicyListVo> policyPageToAutoSelect(Page<PolicyListVo> page, InsuredParam param, String mId);
}
