/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 税友Mapper
 *
 * @author hgw
 * @date 2024-5-13 11:54:57
 */
@Mapper
public interface TSocialFriendMapper extends BaseMapper<TSocialInfo> {
	/**
	 * 社保士兵养工失增加模板
	 *
	 * @Author hgw
	 * @Date 2024-5-10 21:16:41
	 **/
	List<SociaFriendYgsAddVo> getSocialSoldierYgsAddVoList(@Param("idsStr") List<String> idsStr);

	/**
	 * 社保士兵养工失减少模板
	 *
	 * @Author hgw
	 * @Date 2024-5-10 21:16:41
	 **/
	List<SociaFriendYgsAddVo> getSocialSoldierYgsReduceVoList(@Param("idsStr") List<String> idsStr);

	/**
	 * 社保士兵医生大增加模板
	 *
	 * @Author hgw
	 * @Date 2024-5-10 21:16:41
	 **/
	List<SociaFriendYgsAddVo> getSocialSoldierYsdAddVoList(@Param("idsStr") List<String> idsStr);

	/**
	 * 社保士兵医生大减少模板
	 *
	 * @Author hgw
	 * @Date 2024-5-10 21:16:41
	 **/
	List<SociaFriendYgsAddVo> getSocialSoldierYsdReduceVoList(@Param("idsStr") List<String> idsStr);



}
