/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * @author fxj
 * @date 2025-04-07 10:24:30
 */
@Data
@TableName("t_auto_standard_info")
@Schema(description = "购买标准配存储表")
public class TAutoStandardInfo {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 关联主表ID
	 */
	@ExcelAttribute(name = "关联主表ID", maxLength = 32)
	@Length(max = 32, message = "关联主表ID不能超过32个字符")
	@ExcelProperty("关联主表ID")
	@Schema(description = "关联主表ID")
	private String mainId;
	/**
	 * 购买标准
	 */
	@ExcelAttribute(name = "购买标准", isNotEmpty = true, errorInfo = "购买标准不能为空", maxLength = 32)
	@NotBlank(message = "购买标准不能为空")
	@ExcelProperty("购买标准")
	@Schema(description = "购买标准")
	private String standard;

}
