/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 完整度监控配置
 *
 * @author hgw
 * @date 2025-02-26 15:18:51
 */
@Data
@TableName("t_complete_monitor_set_base_info")
@Schema(description = "完整度监控配置")
public class TCompleteMonitorSetBaseInfo {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private Integer id;
	/**
	 * 类型（1档案基础信息2默认联动信息3监控信息项）
	 */
	@ExcelAttribute(name = "类型（1档案基础信息2默认联动信息3监控信息项）", isNotEmpty = true, errorInfo = "类型（1档案基础信息2默认联动信息3监控信息项）不能为空", maxLength = 1)
	@NotBlank(message = "类型（1档案基础信息2默认联动信息3监控信息项）不能为空")
	@Length(max = 1, message = "类型（1档案基础信息2默认联动信息3监控信息项）不能超过1个字符")
	@ExcelProperty("类型（1档案基础信息2默认联动信息3监控信息项）")
	@Schema(description = "类型（1档案基础信息2默认联动信息3监控信息项）")
	private String baseType;
	/**
	 * 序号
	 */
	@ExcelAttribute(name = "序号", isNotEmpty = true, errorInfo = "序号不能为空")
	@NotBlank(message = "序号不能为空")
	@ExcelProperty("序号")
	@Schema(description = "序号")
	private Integer baseNum;
	/**
	 * 字段名称
	 */
	@ExcelAttribute(name = "字段名称", isNotEmpty = true, errorInfo = "字段名称不能为空", maxLength = 50)
	@NotBlank(message = "字段名称不能为空")
	@Length(max = 50, message = "字段名称不能超过50个字符")
	@ExcelProperty("字段名称")
	@Schema(description = "字段名称")
	private String baseName;
	/**
	 * 字段说明
	 */
	@ExcelAttribute(name = "字段说明", maxLength = 50)
	@Length(max = 50, message = "字段说明不能超过50个字符")
	@ExcelProperty("字段说明")
	@Schema(description = "字段说明")
	private String baseRemark;
	/**
	 * 是否监控0否1是
	 */
	@ExcelAttribute(name = "是否监控0否1是", isNotEmpty = true, errorInfo = "是否监控0否1是不能为空", maxLength = 1)
	@NotBlank(message = "是否监控0否1是不能为空")
	@Length(max = 1, message = "是否监控0否1是不能超过1个字符")
	@ExcelProperty("是否监控0否1是")
	@Schema(description = "是否监控0否1是")
	private String isMonitor;
	/**
	 * 表字段
	 */
	@ExcelAttribute(name = "表字段", maxLength = 100)
	@Length(max = 100, message = "表字段不能超过100个字符")
	@ExcelProperty("表字段")
	@Schema(description = "表字段")
	private String baseColumn;
	/**
	 * 表名称
	 */
	@ExcelAttribute(name = "表名称", maxLength = 200)
	@Length(max = 200, message = "表名称不能超过200个字符")
	@ExcelProperty("表名称")
	@Schema(description = "表名称")
	private String baseTable;
	/**
	 * 属性字段
	 */
	@ExcelAttribute(name = "属性字段", maxLength = 100)
	@Length(max = 100, message = "属性字段不能超过100个字符")
	@ExcelProperty("属性字段")
	@Schema(description = "属性字段")
	private String baseField;

}
