/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 商险购买规则配置表
 *
 * @author fxj
 * @date 2025-04-01 10:14:09
 */
@Data
public class TAutoInsurRuleInfoVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键")
	@Schema(description = "主键")
	@ExcelProperty("主键")
	private String id;
	/**
	 * 是否启用自动化：0是 1否
	 */
	@NotBlank(message = "是否启用自动化不能为空")
	@ExcelAttribute(name = "是否启用自动化", isNotEmpty = true, errorInfo = "是否启用自动化不能为空")
	@Schema(description = "是否启用自动化")
	@ExcelProperty("是否启用自动化")
	private Integer autoFlag;
	/**
	 * 投保方式：0自动1 手动
	 */
	@NotBlank(message = "投保方式不能为空")
	@ExcelAttribute(name = "投保方式", isNotEmpty = true, errorInfo = "投保方式不能为空")
	@Schema(description = "投保方式")
	@ExcelProperty("投保方式")
	private Integer addType;
	/**
	 * 续保方式：0自动1 手动
	 */
	@NotBlank(message = "续保方式")
	@ExcelAttribute(name = "续保方式", isNotEmpty = true, errorInfo = "续保方式不能为空")
	@Schema(description = "续保方式")
	@ExcelProperty("续保方式")
	private Integer updateType;
	/**
	 * 退保方式：0自动1 手动
	 */
	@NotBlank(message = "退保方式 不能为空")
	@ExcelAttribute(name = "退保方式", isNotEmpty = true, errorInfo = "退保方式不能为空")
	@Schema(description = "退保方式")
	@ExcelProperty("退保方式")
	private Integer reduceType;
	/**
	 * 投保派单日期类型 0 入职日期前一天
	 */
	@ExcelAttribute(name = "投保派单日期类型")
	@Schema(description = "投保派单日期类型")
	@ExcelProperty("投保派单日期类型")
	private Integer addAutoType;
	/**
	 * 投保派单日期投保时间
	 */
	@Length(max = 10, message = "投保派单日期投保时间 不能超过10 个字符")
	@ExcelAttribute(name = "投保派单日期投保时间")
	@Schema(description = "投保派单日期投保时间")
	@ExcelProperty("投保派单日期投保时间")
	private String addAutoDate;
	/**
	 * 保单开始时间 类型 0 入职当日
	 */
	@ExcelAttribute(name = "保单开始时间")
	@Schema(description = "保单开始时间类型 0 入职当日")
	@ExcelProperty("保单开始时间类型")
	private Integer addStartDate;
	/**
	 * 续保派单日期类型 0 上一份保单截止日期
	 */
	@ExcelAttribute(name = "续保派单日期类型")
	@Schema(description = "续保派单日期类型 0 上一份保单截止日期")
	@ExcelProperty("续保派单日期类型")
	private Integer updateAutoType;
	/**
	 * 续保派单日期续保时间
	 */
	@Length(max = 10, message = "续保派单日期续保时间 不能超过10 个字符")
	@ExcelAttribute(name = "续保派单日期续保时间")
	@Schema(description = "续保派单日期续保时间")
	@ExcelProperty("续保派单日期续保时间")
	private String updateAutoDate;
	/**
	 * 续保保单开始时间 0 上一份保单截止日期+1天
	 */
	@ExcelAttribute(name = "续保保单开始时间")
	@Schema(description = "续保保单开始时间 0 上一份保单截止日期+1天")
	@ExcelProperty("续保保单开始时间")
	private Integer updateStartDate;
	/**
	 * 退保派单日期类型 0 离职日期
	 */
	@ExcelAttribute(name = "退保派单日期类型")
	@Schema(description = "退保派单日期类型 0 离职日期")
	@ExcelProperty("退保派单日期类型")
	private Integer reduceAutoType;
	/**
	 * 退保派单日期退保时间
	 */
	@Length(max = 10, message = "退保派单日期退保时间 不能超过10 个字符")
	@ExcelAttribute(name = "退保派单日期退保时间")
	@Schema(description = "退保派单日期退保时间")
	@ExcelProperty("退保派单日期退保时间")
	private String reduceAutoDate;
	/**
	 * 退保保单失效时间 0 离职日期+1天
	 */
	@ExcelAttribute(name = "退保保单失效时间")
	@Schema(description = "退保保单失效时间 0 离职日期+1天")
	@ExcelProperty("退保保单失效时间")
	private Integer reduceStartDate;
	/**
	 * 项目配置主表ID
	 */
	@Length(max = 32, message = "项目配置主表ID 不能超过32 个字符")
	@ExcelAttribute(name = "项目配置主表ID")
	@Schema(description = "项目配置主表ID")
	@ExcelProperty("项目配置主表ID")
	private String mainId;
	/**
	 * 默认信息是否允许修改 0是 1否
	 */
	@NotBlank(message = "默认信息是否允许修改不能为空")
	@ExcelAttribute(name = "默认信息是否允许修改", isNotEmpty = true, errorInfo = "默认信息是否允许修改 不能为空")
	@Schema(description = "默认信息是否允许修改 0是 1否")
	@ExcelProperty("默认信息是否允许修改")
	private Integer updateFlag;

}
