package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TRiskMonitor;
import com.yifu.cloud.plus.v1.yifu.archives.service.TRiskMonitorService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TRiskMonitorSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;


/**
 * 风险管控统计
 *
 * @author huych
 * @date 2024-09-25 10:01:06
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/triskmonitor")
@Tag(name = "风险管控统计管理")
public class TRiskMonitorController {

	private final TRiskMonitorService tRiskMonitorService;

	/**
	 * 通过id查询风险管控统计
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('archives_triskmonitor_get')")
	@GetMapping("/{id}")
	public R<TRiskMonitor> getById(@PathVariable("id") String id) {
		return R.ok(tRiskMonitorService.getById(id));
	}

	/**
	 * 简单分页查询
	 *
	 * @param page         分页对象
	 * @param tRiskMonitor 风险管控统计
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TRiskMonitor>> getTRiskMonitorPage(Page<TRiskMonitor> page, TRiskMonitorSearchVo tRiskMonitor) {
		return new R<>(tRiskMonitorService.getTRiskMonitorPage(page, tRiskMonitor));
	}

	/**
	 * 新增风险管控统计
	 *
	 * @param tRiskMonitor 风险管控统计
	 * @return R
	 */
	@Operation(summary = "新增风险管控统计", description = "新增风险管控统计：hasPermission('archives_triskmonitor_add')")
	@SysLog("新增风险管控统计")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('archives_triskmonitor_add')")
	public R<Boolean> save(@RequestBody TRiskMonitor tRiskMonitor) {
		return R.ok(tRiskMonitorService.save(tRiskMonitor));
	}

	/**
	 * 通过id删除风险管控统计
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除风险管控统计", description = "通过id删除风险管控统计：hasPermission('archives_triskmonitor_del')")
	@SysLog("通过id删除风险管控统计")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_triskmonitor_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(tRiskMonitorService.removeById(id));
	}

	/**
	 * 风险管控统计 批量导出
	 *
	 * @author huych
	 * @date 2024-09-25 10:01:06
	 **/
	@Operation(description = "导出风险管控统计 hasPermission('archives_triskmonitor-export')")
	@PostMapping("/export")
	public void export(HttpServletResponse response, @RequestBody TRiskMonitorSearchVo searchVo) {
		tRiskMonitorService.listExport(response, searchVo);
	}

	/**
	 * 风险管控统计 批量生成
	 * @author huyc
	 * @date 2024-09-27 14:08:58
	 **/
	@Operation(description = "生成风险管控统计")
	@Inner
	@PostMapping("/inner/createRiskMonitor")
	public void createRiskMonitor(){
		tRiskMonitorService.createRiskMonitor();
	}

	/**
	 * 查询风险占比
	 * @author huyc
	 * @date 2024-06-17 16:08:58
	 **/
	@Operation(description = "查询风险占比")
	@PostMapping("/selectCurrentRiskMonitor")
	public R selectCurrentRiskMonitor(@RequestBody TRiskMonitorSearchVo tRiskMonitor) {
		return tRiskMonitorService.selectCurrentRiskMonitor(tRiskMonitor);
	}
}
