package com.yifu.cloud.plus.v1.business.entity.vacation;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 假期规则配置
 * @TableName t_vacation_rule_config
 */
@TableName(value ="t_vacation_rule_config")
@Data
public class TVacationRuleConfig extends Model<TVacationRuleConfig> {
	/**
	 *
	 */
	@TableId(type = IdType.ASSIGN_ID)
	private String id;

    /**
     * 假期类型 1年假
     */
    private String type;

    /**
     * 是否自动发放假期时间 0否 1是
     */
    private String vacationAutoInit;

    /**
     * 假期初始化时间
     */
    private LocalDate vacationInitDate;

    /**
     * 时间刻度 1按小时（和TIME_VALUE字段一起保证一天可以被不同单位数量的时间转换）
     */
    private String timeScale;

    /**
     * 以时间刻度为单位的时间值（和TIME_SCALE字段一起保证一天可以被不同单位数量的时间转换）
     */
    private BigDecimal timeValue;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 最后更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建人id
     */
    private String createUserId;

    /**
     * 最后更新人id
     */
    private String updateUserId;

    public static <T> T entityConvertToObj(T t, TVacationRuleConfig entity) {
        BeanUtil.copyProperties(entity, t, CopyOptions.create().setIgnoreNullValue(true));
        return t;
    }

    public static TVacationRuleConfig objConvertToEntity(Object obj) {
        TVacationRuleConfig entity = new TVacationRuleConfig();
        BeanUtil.copyProperties(obj, entity, CopyOptions.create().setIgnoreNullValue(true));
        return entity;
    }

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}