package com.yifu.cloud.plus.v1.business.controller.vacation;

import com.yifu.cloud.plus.v1.business.dto.vacation.AddOrSaveVacationRuleDTO;
import com.yifu.cloud.plus.v1.business.service.vacation.TVacationRuleConfigService;
import com.yifu.cloud.plus.v1.business.util.BusinessResultErrorMsg;
import com.yifu.cloud.plus.v1.business.vo.vacation.VacationRuleConfigVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * @description: 假期配置controller
 * @author: huyc
 * @date: 2023/1/13
 */
@AllArgsConstructor
@RequestMapping("/vacationRule")
@RestController
@Tag(name = "假期配置表")
public class TVacationRuleConfigController {

    private final TVacationRuleConfigService tVacationRuleConfigService;

    /**
     * @description: 获取年假配置规则
     * @return: com.yifu.cloud.v1.common.core.util.R<com.yifu.cloud.v1.hrobusiness.api.vo.vacation.VacationRuleConfigVO>
	 * @author: huyc
	 * @date: 2023/1/13
     */
	@Operation(summary = "获取年假配置规则", description = "获取年假配置规则")
	@GetMapping("/getVacationRuleConfig")
    public R<VacationRuleConfigVO> getVacationRuleConfig() {
        YifuUser user = SecurityUtils.getUser();
        if (null == user) {
            R.failed(BusinessResultErrorMsg.USER_NOT_LOGIN);
        }
        return this.tVacationRuleConfigService.getVacationRuleConfig();
    }

    /**
     * @description:
     * @param dto
     * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
     */
	@Operation(summary = "新增或保存假期配置规则", description = "新增或保存假期配置规则")
	@PostMapping("/addOrSave")
    public R<Boolean> addOrSave(@Valid @RequestBody AddOrSaveVacationRuleDTO dto) {
        YifuUser user = SecurityUtils.getUser();
        if (null == user) {
            R.failed(BusinessResultErrorMsg.USER_NOT_LOGIN);
        }
        return this.tVacationRuleConfigService.addOrSave(user, dto);
    }

}
