/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.check.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * C端预入职校验身份证与手机号限定调用表
 *
 * @author hgw
 * @date 2024-06-27 14:33:06
 */
@Data
@TableName("t_pre_emp_check_num")
@Schema(description = "C端预入职校验身份证与手机号限定调用表")
public class TPreEmpCheckNum implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 创建日
	 */
	@ExcelAttribute(name = "创建日", isNotEmpty = true, errorInfo = "创建日不能为空", maxLength = 8)
	@NotBlank(message = "创建日不能为空")
	@Length(max = 8, message = "创建日不能超过8个字符")
	@ExcelProperty("创建日")
	@Schema(description = "创建日")
	private String createDay;
	/**
	 * 项目id
	 */
	@ExcelAttribute(name = "项目id", isNotEmpty = true, errorInfo = "项目id不能为空", maxLength = 32)
	@NotBlank(message = "项目id不能为空")
	@Length(max = 32, message = "项目id不能超过32个字符")
	@ExcelProperty("项目id")
	@Schema(description = "项目id")
	private String deptId;
	/**
	 * 当日调用API总条数
	 */
	@ExcelAttribute(name = "当日调用API总条数", isNotEmpty = true, errorInfo = "当日调用API总条数不能为空")
	@NotBlank(message = "当日调用API总条数不能为空")
	@ExcelProperty("当日调用API总条数")
	@Schema(description = "当日调用API总条数")
	private Integer apiNum;
	/**
	 * 当日允许调用API总条数
	 */
	@ExcelAttribute(name = "当日允许调用API总条数", isNotEmpty = true, errorInfo = "当日允许调用API总条数不能为空")
	@NotBlank(message = "当日允许调用API总条数不能为空")
	@ExcelProperty("当日允许调用API总条数")
	@Schema(description = "当日允许调用API总条数")
	private Integer canApiNum;

}
