package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.alibaba.fastjson.JSON;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprInsurancesProperties;
import com.yifu.cloud.plus.v1.yifu.social.vo.ChangeDeptVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

/**
 * @Author hgw
 * @Date 2022-11-17 10:16:59
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprInsurancesProperties.class)
public class InsuranceDaprUtil {
	@Autowired
	private DaprInsurancesProperties daprInsurancesProperties;
	/**
	 * @Author hgw
	 * @Description ekp费用划转，商险划转项目
	 * @Date 2022-11-17 11:03:08
	 * @Param
	 * @return
	**/
	public void ekpUpdateInsuranceDept(ChangeDeptVo changeDeptVo){
		HttpDaprUtil.invokeMethodPost(daprInsurancesProperties.getAppUrl()
				, daprInsurancesProperties.getAppId(),"/insuranceDetail/inner/ekpUpdateInsuranceDept" , changeDeptVo
				, Object.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 新增商险待购买信息
	 * @Date 14:34 2025/4/3
	 * @Param
	 * @return
	 **/
	public R<Boolean> saveInsurancePreInfo(EmployeeRegistrationPreVo preVo) {
		return HttpDaprUtil.invokeMethodPost(daprInsurancesProperties.getAppUrl(),daprInsurancesProperties.getAppId(),
				"/temployeeinsurancepre/inner/saveInsurancePreInfo", JSON.toJSONString(preVo), Boolean.class, SecurityConstants.FROM_IN);
	}

}
