package com.yifu.cloud.plus.v1.yifu.process.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 流程路由表（节点与节点之间的路由关系）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_node_route")
@Schema(description = "流程路由表（节点与节点之间的路由关系）")
public class TNodeRoute extends Model<TNodeRoute> {
     private static final long serialVersionUID = 1L;

     @TableId(type = IdType.ASSIGN_ID)
	 @Schema(description = "主键")
     private String id;

     @NotBlank(message = "流程ID不能为空")
     @Length(max = 255, message = "流程ID不能超过255个字符")
	 @Schema(description = "流程ID")
     private String processId;

     @Length(max = 255, message = "前置节点不能超过255个字符")
	 @Schema(description = "前置节点")
     private String prewNode;

     @NotBlank(message = "下个节点不能为空")
     @Length(max = 255, message = "下个节点不能超过255个字符")
	 @Schema(description = "下个节点")
     private String nextNode;

     @Length(max = 1, message = "连线起点位置不能超过1个字符")
	 @Schema(description = "连线起点位置")
     private String preNodeAnchor;

     @Length(max = 1, message = "连线终点位置不能超过1个字符")
	 @Schema(description = "连线终点位置")
     private String nextNodeAnchor;

     @Length(max = 100, message = "元素的图形：不能超过100个字符")
	 @Schema(description = "元素的图形")
     private String shape;

     @Length(max = 255, message = "标识（系统自动生成MD5串）不能超过255个字符")
	 @Schema(description = "标识（系统自动生成MD5串）")
     private String logoTitle;

     @NotBlank(message = "创建人不能为空")
     @Length(max = 255, message = "创建人不能超过255个字符")
	 @Schema(description = "创建人")
     private String createUser;

	 @Schema(description = "创建时间")
	 @JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
     private LocalDateTime createDate;

     @Length(max = 255, message = "更新人不能超过255个字符")
	 @Schema(description = "更新人")
     private String updateUser;

	 @Schema(description = "更新时间")
     private LocalDateTime updateDate;

     @NotBlank(message = "路由名称（默认为“未命名”，添加时需要保存格式为：前置节点名称（to：下一节点名称））不能为空")
     @Length(max = 255, message = "路由名称（默认为“未命名”，添加时需要保存格式为：前置节点名称（to：下一节点名称））不能超过255个字符")
	 @Schema(description = "路由名称（默认为“未命名”，添加时需要保存格式为：前置节点名称（to：下一节点名称））")
     private String name;

     @Length(max = 255, message = "描述不能超过255个字符")
	 @Schema(description = "描述")
     private String description;

	 @Schema(description = "顺序号")
     private Integer sequenceNo;

     @Length(max = 255, message = "默认意见不能超过255个字符")
	 @Schema(description = "默认意见")
     private String opinion;

     @NotBlank(message = "意见是否必填（0是/1否）不能为空")
     @Length(max = 1, message = "意见是否必填（0是/1否）不能超过1个字符")
	 @Schema(description = "意见是否必填（0是/1否）")
     private String opinionMustFlag;

     @NotBlank(message = "路由类型（1默认路由/2回退路由/3转交（转交不触发活动事件））不能为空")
     @Length(max = 1, message = "路由类型（1默认路由/2回退路由/3转交（转交不触发活动事件））不能超过1个字符")
     @Schema(description = "路由类型（1默认路由/2回退路由/3转交（转交不触发活动事件））")
     private String routeType;

     @NotBlank(message = "是否优先（0是/1否：仅在分支/并列下使用，单节点路由不存在优先级）不能为空")
     @Length(max = 1, message = "是否优先（0是/1否：仅在分支/并列下使用，单节点路由不存在优先级）不能超过1个字符")
	 @Schema(description = "是否优先（0是/1否：仅在分支/并列下使用，单节点路由不存在优先级）")
     private String priorityFlag;

     @NotBlank(message = "活动超时时自动流转（0是/1否）不能为空")
     @Length(max = 1, message = "活动超时时自动流转（0是/1否）不能超过1个字符")
	 @Schema(description = "活动超时时自动流转（0是/1否）")
     private String timeoutRoam;

     @NotBlank(message = "与上一活动处理人相同时自动流转（0是/1否）不能为空")
     @Length(max = 1, message = "与上一活动处理人相同时自动流转（0是/1否）不能超过1个字符")
	 @Schema(description = "与上一活动处理人相同时自动流转（0是/1否）")
     private String sameForPrew;

	 @TableField(exist = false)
     List<TNodeRouteCondition> nodeRouteConditionList;
}
