/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 银企付款查询卡号所属行号记录表——有可能重复
 *
 * @author hgw
 * @date 2024-11-18 17:04:20
 */
@Data
@TableName("ekp_bank_code_set")
@Schema(description = "银企付款查询卡号所属行号记录表")
public class EkpBankCodeSet {

	/**
	 * fdId
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("fdId")
	@Schema(description = "fdId")
	private String fdId;
	/**
	 * 卡号
	 */
	@ExcelAttribute(name = "卡号", isNotEmpty = true, errorInfo = "卡号不能为空", maxLength = 50)
	@NotBlank(message = "卡号不能为空")
	@Length(max = 50, message = "卡号不能超过50个字符")
	@ExcelProperty("卡号")
	@Schema(description = "卡号")
	private String fdPayeeAccount;
	/**
	 * 收款账号开户行
	 */
	@ExcelAttribute(name = "收款账号开户行", maxLength = 100)
	@Length(max = 100, message = "收款账号开户行不能超过100个字符")
	@ExcelProperty("收款账号开户行")
	@Schema(description = "收款账号开户行")
	private String fdRecipientBank;
	/**
	 * 收款银行人行行号
	 */
	@ExcelAttribute(name = "收款银行人行行号", maxLength = 100)
	@Length(max = 100, message = "收款银行人行行号不能超过100个字符")
	@ExcelProperty("收款银行人行行号")
	@Schema(description = "收款银行人行行号")
	private String fdRecipientBankCode;

	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	private LocalDateTime fdCreateTime;

}
