package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 商险待办任务表
 *
 * @author huych
 * @date 2025-03-31 12:25:13
 */
@Data
@TableName("t_employee_insurance_pre")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "商险待办任务表")
public class TEmployeeInsurancePre extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "id")
	private String id;

	@Schema(description = "员工姓名")
	private String employeeName;

	@Schema(description = "身份证号")
	private String empIdcard;

	@Schema(description = "手机号码")
	private String empPhone;

	@Schema(description = "入职日期")
	private Date joinLeaveDate;

	@Schema(description = "状态,0待确认,1待派单,2派单失败,3待投保,4投保中,5投保退回,6已完成")
	private String processStatus;

	@Schema(description = "前端客服")
	private String customerUsername;

	@Schema(description = "前端客服登录名")
	private String customerUserLoginname;

	@Schema(description = "项目名称")
	private String deptName;

	@Schema(description = "项目编码")
	private String deptNo;

	@Schema(description = "项目id")
	private String deptId;

	@Schema(description = "预计派单时间")
	private LocalDateTime expectedCollectionTime;

	@Schema(description = "登记人")
	private String registUser;

	@Schema(description = "登记时间")
	private LocalDateTime registTime;

	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	@Schema(description = "险种名称")
	private String insuranceTypeName;

	@Schema(description = "险种主键")
	private String insuranceTypeId;

	@Schema(description = "购买标准")
	private String buyStandard;

	@Schema(description = "购买类型， 1新增、3批增、4替换")
	private Integer buyType;

	@Schema(description = "保单开始时间")
	private Date policyStart;

	@Schema(description = "保单结束时间")
	private Date policyEnd;

	@Schema(description = "保单号")
	private String policyNo;

	@Schema(description = "是否地市自购0是 1 否")
	private String isAddress;

	@Schema(description = "就职岗位")
	private String position;

	@Schema(description = "数据来源1客户端 2客服端")
	private String dataSource;

	@Schema(description = "购买地-省")
	private String fileProvince;

	@Schema(description = "购买地-市")
	private String fileCity;

	@Schema(description = "购买地-省id")
	private String provinceCode;

	@Schema(description = "购买地-市id")
	private String cityCode;

	@Schema(description = "入离职登记主表id")
	private String registerId;

	@Schema(description = "替换员工姓名")
	private String replaceEmployeeName;

	@Schema(description = "替换身份证号")
	private String replaceEmpIdcard;

	@Schema(description = "替换项目编码")
	private String replaceDeptNo;

}
