package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import java.io.Serializable;
/**
 * @author 张云
 * @description 减员退费导入表
 * @date 2022-12-09 10:06:31
 */
@Data
@Tag(name = "减员退费导入表")
public class RefundMoneyUpdateParam implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 主键
	 */
	@JsonIgnore
	private String id;

	/**
	 * 商险id
	 */
	@JsonIgnore
	private String insDetailId;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 保单开始时间
	 */
	@Schema(description = "保单开始时间")
	private String policyStart;

	/**
	 * 保单结束时间
	 */
	@Schema(description = "保单结束时间")
	private String policyEnd;

	/**
	 * 保险公司名称(冗余字段)
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 退款金额（元）
	 */
	@Schema(description = "退款金额（元）")
	private String refundMoney;

	/**
	 * 错误原因
	 */
	@Schema(description = "错误原因")
	private String errorMessage;

}
