package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CacheConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ResultConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.redis.RedisDistributedLock;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.constants.InsurancesConstants;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceOperate;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceDetailService;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.*;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount;
import com.yifu.cloud.plus.v1.yifu.salary.vo.SalaryRiskListVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.ChangeDeptVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * @author licancan
 * @description 针对表【t_insurance_detail(商险明细表)】的数据库操作controller
 * @date 2022-07-18 16:38:48
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/insuranceDetail")
@Tag(name = "商险相关")
@Validated
public class TInsuranceDetailController {
	@Resource
	private TInsuranceDetailService tInsuranceDetailService;

	/***********************商险办理********************************/

	/**
	 * 每日定时刷新商险到期数据
	 *
	 * @author licancan
	 * @param
	 * @return void
	 */
	@SysLog("每日定时刷新商险到期数据")
	@Inner
	@PostMapping("/inner/updateOverdueByTask")
	public void updateOverdueByTask() {
		tInsuranceDetailService.updateOverdueByTask();
	}

	/**
	 * EKP2INSURANCES 更新结算状态（已弃用）
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<String>}
	 */
	@Deprecated
	@Operation(summary = "更新结算状态", description = "更新结算状态")
	@PostMapping("/updateInsuranceSettle")
	public R<String> updateInsuranceSettle(@RequestBody UpdateInsuranceSettleParam param) {
		return tInsuranceDetailService.updateInsuranceSettle(param);
	}

	/**
	 * 投保分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param param
	 * @return {@link R<IPage<InsuranceListVO>>}
	 */
	@Operation(summary = "投保分页查询", description = "投保分页查询")
	@PostMapping("/getInsuranceListPage")
	public R<IPage<InsuranceListVO>> getInsuranceListPage(Page<InsuranceListVO> page, @RequestBody InsuranceListParam param,
														  @RequestParam(required = false) String mId) {
		return R.ok(tInsuranceDetailService.getInsuranceListPage(page, param, mId));
	}

	/**
	 * 投保不分页查询
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<List<InsuranceListVO>>}
	 */
	@Operation(summary = "投保不分页查询", description = "投保不分页查询")
	@PostMapping("/getInsuranceList")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insure_export')")
	public R<List<InsuranceListVO>> getInsuranceList(@RequestBody InsuranceListParam param,@RequestParam(required = false) String mId) {
		return tInsuranceDetailService.getInsuranceList(param,mId);
	}

	/**
	 * 投保办理分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param param
	 * @return {@link R<IPage<InsuranceListVO>>}
	 */
	@Operation(summary = "投保办理分页查询", description = "投保办理分页查询")
	@PostMapping("/getInsuranceHandleListPage")
	public R<IPage<InsuranceListVO>> getInsuranceHandleListPage(Page<InsuranceListVO> page, @RequestBody InsuranceListParam param,
																@RequestParam(required = false) String mId) {
		return R.ok(tInsuranceDetailService.getInsuranceHandleListPage(page, param, mId));
	}

	/**
	 * 商险新增
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceAddParam>>}
	 */
	@Operation(summary = "投保新增", description = "投保新增")
	@PostMapping("/addInsurance")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insure_add')")
	public R<List<InsuranceAddParam>> addInsurance(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<InsuranceAddParam> paramList){
		return tInsuranceDetailService.addInsurance(paramList,null);
	}

	/**
	 * 商险批增
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceBatchParam>>}
	 */
	@Operation(summary = "投保批增", description = "投保批增")
	@PostMapping("/batchInsurance")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insure_batch_add')")
	public R<List<InsuranceBatchParam>> batchInsurance(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<InsuranceBatchParam> paramList){
		return tInsuranceDetailService.batchInsurance(paramList,null);
	}

	/**
	 * 商险替换
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceReplaceParam>>}
	 */
	@Operation(summary = "投保替换", description = "投保替换")
	@PostMapping("/replaceInsurance")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insure_update')")
	public R<List<InsuranceReplaceParam>> replaceInsurance(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<InsuranceReplaceParam> paramList){
		return tInsuranceDetailService.replaceInsurance(paramList,null);
	}

	/**
	 * 通过id删除
	 *
	 * @author licancan
	 * @param id
	 * @return {@link R<String>}
	 */
	@GetMapping("/deleteInsurance")
	@Operation(summary = "通过id删除", description = "通过id删除")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insure_delete')")
	public R<String> deleteInsurance(@RequestParam String id) {
		return tInsuranceDetailService.deleteInsurance(id);
	}

	/**
	 * 编辑
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<String>}
	 */
	@PostMapping("/editInsurance")
	@Operation(summary = "编辑", description = "编辑")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insure_edit')")
	public R<String> editInsurance(@RequestBody @Valid InsuranceEditParam param) {
		return tInsuranceDetailService.editInsurance(param);
	}

	/**
	 * 通过id查询
	 *
	 * @author licancan
	 * @param id
	 * @return {@link R<InsuranceDetailVO>}
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}")
	public R<InsuranceDetailVO> getInsuranceDetailById(@PathVariable("id") String id) {
		return R.ok(tInsuranceDetailService.getInsuranceDetailById(id));
	}

	/**
	 * 通过商险id查询操作记录
	 *
	 * @author licancan
	 * @param id
	 * @return {@link R< List<TInsuranceOperate>>}
	 */
	@Operation(summary = "通过商险id查询操作记录", description = "通过商险id查询操作记录")
	@GetMapping("/operate/{id}")
	public R<List<TInsuranceOperate>> getInsuranceOperateList(@PathVariable("id") String id) {
		return R.ok(tInsuranceDetailService.getInsuranceOperateList(id));
	}

	/**
	 * 导出办理
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<List<InsuranceExportListVO>>}
	 */
	@Operation(summary = "导出办理", description = "导出办理")
	@PostMapping("/getInsuranceExportList")
	@PreAuthorize("@pms.hasPermission('handle_insure_export')")
	public R<List<InsuranceExportListVO>> getInsuranceExportList(@RequestBody InsuranceExportListParam param,
																 @RequestParam(required = false) String mId) {
		return tInsuranceDetailService.getInsuranceExportList(param,mId);
	}

	/**
	 * 导出办理(新)
	 *
	 * @author huyc
	 * @param param
	 * @return {@link R<List<InsuranceExportListOneVO>>}
	 */
	@Operation(summary = "导出办理(新)", description = "导出办理(新)")
	@PostMapping("/getInsuranceExportOneList")
	@PreAuthorize("@pms.hasPermission('handle_insure_export')")
	public R<List<InsuranceExportListOneVO>> getInsuranceExportOneList(@RequestBody InsuranceExportListParam param,
																 @RequestParam(required = false) String mId) {
		return tInsuranceDetailService.getInsuranceExportOneList(param,mId);
	}

	/**
	 * 投保退回
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceListVO>>}
	 */
	@Operation(summary = "投保退回", description = "投保退回")
	@PostMapping("/rollBackInsurance")
	@PreAuthorize("@pms.hasPermission('handle_insure_back')")
	public R<List<InsuranceListVO>> rollBackInsurance(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<InsuranceHandleParam> paramList){
		YifuUser user = SecurityUtils.getUser();
		if (user == null || Common.isEmpty(user.getId())) {
			return R.failed(CommonConstants.PLEASE_LOG_IN);
		}
		return tInsuranceDetailService.rollBackInsurance(user,paramList);
	}

	/**
	 * 投保成功/退回办理导入
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<List<InsuranceHandleImportParam>>}
	 */
	@Operation(summary = "投保成功/退回办理导入", description = "投保成功/退回办理导入")
	@PostMapping("/insuranceHandleImport")
	@PreAuthorize("@pms.hasPermission('handle_insure_cost')")
	public R<List<InsuranceHandleImportParam>> insuranceHandleImport(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<InsuranceHandleImportParam> param) {
		YifuUser user = SecurityUtils.getUser();
		if (user == null || Common.isEmpty(user.getId())) {
			return R.failed(CommonConstants.PLEASE_LOG_IN);
		}
		if(param.size() > CommonConstants.IMPORT_TWENTY_THOUSAND){
			return R.failed(InsurancesConstants.IMPORT_TOO_LONG);
		}
		return tInsuranceDetailService.insuranceHandleImport(user,param);
	}

	/**
	 * 办理成功
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceListVO>>}
	 */
	@Operation(summary = "办理成功", description = "办理成功")
	@PostMapping("/successfulInsurance")
	@PreAuthorize("@pms.hasPermission('handle_insure')")
	public R<List<InsuranceListVO>> successfulInsurance(@RequestBody @Valid  @Size(min = 1,message = "集合不能为空") List<InsuranceHandleParam> paramList){
		YifuUser user = SecurityUtils.getUser();
		if (user == null || Common.isEmpty(user.getId())) {
			return R.failed(CommonConstants.PLEASE_LOG_IN);
		}
		return tInsuranceDetailService.successfulInsurance(user,paramList);
	}

	/**
	 * 登记保单保费
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceRegisterParam>>}
	 */
	@Operation(summary = "登记保单保费", description = "登记保单保费")
	@PostMapping("/registeredPolicyPremium")
	@PreAuthorize("@pms.hasPermission('handle_insure_cost')")
	public R<List<InsuranceRegisterParam>> registeredPolicyPremium(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<InsuranceRegisterParam> paramList){
		YifuUser user = SecurityUtils.getUser();
		if (Common.isEmpty(user)){
			return R.failed(CommonConstants.USER_FAIL);
		}
		// 获取redis分布式事务锁
		String key = CacheConstants.INSURANCE_BATCH_UPDATE_IMPORT + CommonConstants.DOWN_LINE_STRING + user.getId();
		String requestId;
		try {
			requestId = RedisDistributedLock.getLock(key,"10");
		} catch (Exception e) {
			throw new RuntimeException(ResultConstants.NO_GETLOCK_DATA+CommonConstants.DOWN_LINE_STRING+e.getMessage());
		}
		try {
			if (Common.isNotNull(requestId)) {
				//主动释放锁
				return tInsuranceDetailService.registeredPolicyPremium(paramList);
			} else {
				return R.failed(ResultConstants.NO_GETLOCK_DATA);
			}
		}finally {
			//主动释放锁
			RedisDistributedLock.unlock(key, requestId);
		}

	}

	/**
	 * 登记发票号
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R< List<InsuranceRegisterInvoiceNoParam>>}
	 */
	@Operation(summary = "登记发票号", description = "登记发票号")
	@PostMapping("/registeredInvoiceNo")
	@PreAuthorize("@pms.hasPermission('handle_insure_invoice')")
	public R<List<InsuranceRegisterInvoiceNoParam>> registeredInvoiceNo(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<InsuranceRegisterInvoiceNoParam> paramList){

		YifuUser user = SecurityUtils.getUser();
		if (Common.isEmpty(user)){
			return R.failed(CommonConstants.USER_FAIL);
		}
		// 获取redis分布式事务锁
		String key = CacheConstants.INSURANCE_BATCH_UPDATE_IMPORT + CommonConstants.DOWN_LINE_STRING + user.getId();
		String requestId;
		try {
			requestId = RedisDistributedLock.getLock(key,"10");
		} catch (Exception e) {
			throw new RuntimeException(ResultConstants.NO_GETLOCK_DATA+CommonConstants.DOWN_LINE_STRING+e.getMessage());
		}
		try {
			if (Common.isNotNull(requestId)) {
				//主动释放锁
				return tInsuranceDetailService.registeredInvoiceNo(paramList);
			} else {
				return R.failed(ResultConstants.NO_GETLOCK_DATA);
			}
		}finally {
			//主动释放锁
			RedisDistributedLock.unlock(key, requestId);
		}
	}

	/**
	 * 已投保信息修改
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceInsuredParam>>}
	 */
	@Operation(summary = "已投保信息修改", description = "已投保信息修改")
	@PostMapping("/updateInsuranceInsured")
	@PreAuthorize("@pms.hasPermission('handle_insured')")
	public R<List<InsuranceInsuredParam>> updateInsuranceInsured(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<InsuranceInsuredParam> paramList){
		return tInsuranceDetailService.updateInsuranceInsured(paramList);
	}

	/**
	 * 已投保信息修改
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R< String>}
	 */
	@PostMapping("/updateInsuranceInsuredById")
	@Operation(summary = "已投保信息修改", description = "已投保信息修改")
	@PreAuthorize("@pms.hasPermission('handle_insured_by_id')")
	public R<String> updateInsuranceInsuredById(@RequestBody InsuranceInsuredDetailParam param) {
		return tInsuranceDetailService.updateInsuranceInsuredById(param);
	}
	/***********************减员办理********************************/
	/**
	 * 导入减员校验
	 * @param insuranceRefundCheckList 导入减员校验
	 * @author zhaji
	 * @date 2022-07-19
	 * @since v1.0
	 */
	@PostMapping("/saveInsuranceRefund")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insured_reduce')")
	public R saveInsuranceRefund(@RequestBody @Valid @Size(min = 1,message = "导入减员列表不能为空") List<InsuranceRefundCheck> insuranceRefundCheckList){
		return tInsuranceDetailService.saveInsuranceRefund(insuranceRefundCheckList,null);
	}

	/**
	 * 变更结算月
	 * @param settleMonthCheckList 变更结算月
	 * @author zhaji
	 * @date 2022-07-21
	 * @since v1.0
	 */
	@PostMapping("/settleMonthChange")
	@Operation(summary = "变更结算月", description = "变更结算月")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insured_change_month')")
	public R settleMonthChange(@RequestBody @Valid @Size(min = 1,message = "变更结算月不能为空") List<SettleMonthChangeCheckParam> settleMonthCheckList){
		return tInsuranceDetailService.settleMonthChange(settleMonthCheckList);
	}

	/**
	 * 变更所属项目
	 * @param deptChangeCheckList 变更所属项目
	 * @author zhaji
	 * @date 2022-07-21
	 * @since v1.0
	 */
	@PostMapping("/deptChange")
	@Operation(summary = "变更所属项目", description = "变更所属项目")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insured_change_dept')")
	public R deptChange(@RequestBody @Valid @Size(min = 1,message = "变更所属项目不能为空")List<DeptChangeCheckParam> deptChangeCheckList){
		return tInsuranceDetailService.deptChange(deptChangeCheckList);
	}

	/**
	 * 已投保列表分页查询
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param param 查询条件
	 * @return {@link R<IPage<InsuredListVo>>}
	 */
	@Operation(summary = "已投保列表分页查询", description = "已投保列表分页查询")
	@PostMapping("/getInsuredListPage")
	public R<IPage<InsuredListVo>> getInsuredListPage(Page<InsuredListVo> page, @RequestBody InsuredParam param,
													  @RequestParam(required = false) String mId) {
		return R.ok(tInsuranceDetailService.getInsuredListPage(page,param,mId));
	}

	/**
	 * 已投保列表不分页查询
	 *
	 * @author zhaji
	 * @param param 查询条件
	 * @param response 相应参数
	 * @return void
	 */
	@Operation(summary = "已投保列表不分页查询", description = "已投保列表不分页查询")
	@PostMapping("/getInsuredList")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insured_export')")
	public void getInsuredList(@RequestBody InsuredParam param, HttpServletResponse response) {
		tInsuranceDetailService.getInsuredList(param,response);
	}

	/**
	 * 已减员列表分页查询
	 *
	 * @author zhaji
	 * @param param 查询条件
	 * @return {@link R<IPage<InsuranceRefundListVo>>}
	 */
	@Operation(summary = "已减员列表分页查询", description = "已减员列表分页查询")
	@PostMapping("/getInsuranceRefundPageList")
	public R getInsuranceRefundPageList(Page<InsuranceRefundParam> page, @RequestBody InsuranceRefundParam param,
										@RequestParam(required = false) String mId) {
		return tInsuranceDetailService.getInsuranceRefundPageList(page,param,mId);
	}

	/**
	 * 已减员列表导出
	 *
	 * @author zhaji
	 * @param param 查询条件
	 * @return {@link R<List<InsuranceRefundListVo>>}
	 */
	@Operation(summary = "已减员列表导出", description = "已减员列表导出")
	@PostMapping("/getInsuranceRefundList")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_reduction_export')")
	public R getInsuranceRefundList(@RequestBody InsuranceRefundParam param) {
		return tInsuranceDetailService.getInsuranceRefundList(param);
	}


	/**
	 * 减员办理列表分页查询
	 *
	 * @author zhaji
	 * @param param 查询条件
	 * @return {@link R<IPage<RefundExportListVo>>}
	 */
	@Operation(summary = "减员办理列表分页查询", description = "减员办理列表分页查询")
	@GetMapping("/getInsuranceRefundHandlingPageList")
	public R<IPage<RefundExportListVo>> getInsuranceRefundHandlingPageList(Page<InsuranceRefundHandlingParam> page,InsuranceRefundHandlingParam param,
																		   @RequestParam(required = false) String mId) {
		return R.ok(tInsuranceDetailService.getInsuranceRefundHandlingPageList(page,param,mId));
	}

	/**
	 * 导出减员列表
	 *
	 * @author zhaji
	 * @param param 查询条件
	 * @return {@link R<List<RefundExportListVo>>}
	 */
	@Operation(summary = "导出减员列表", description = "导出减员列表")
	@PostMapping("/getInsuranceRefundHandlingList")
	@PreAuthorize("@pms.hasPermission('handle_down_export')")
	public R getInsuranceRefundHandlingList(@RequestBody RefundExportListParam param, @RequestParam(required = false) String mId) {
		return tInsuranceDetailService.getInsuranceRefundHandlingList(param,mId);
	}

	/**
	 * 减员办理
	 *
	 * @author zhaji
	 * @param insuranceDetail 减员信息
	 * @return {@link R<List<  RefundExportListVo  >>}
	 */
	@Operation(summary = "减员办理", description = "减员办理")
	@PostMapping("/updateInsuranceRefund")
	@PreAuthorize("@pms.hasPermission('handle_down_sucess')")
	public R updateInsuranceRefund(@RequestBody InsuranceRefundListParam insuranceDetail) {
		return tInsuranceDetailService.updateInsuranceRefund(insuranceDetail);
	}

	/**
	 * 减员办理导入
	 *
	 * @author zhaji
	 * @param insuranceRefundImportList 减员信息
	 * @return {@link R<List< InsuranceHandleImportParam >>}
	 */
	@Operation(summary = "减员办理导入", description = "减员办理导入")
	@PostMapping("/insuranceRefundImport")
	@PreAuthorize("@pms.hasPermission('handle_down_batch')")
	public R insuranceRefundImport(@RequestBody List<InsuranceHandleImportParam> insuranceRefundImportList) {
		return tInsuranceDetailService.insuranceRefundImport(insuranceRefundImportList);
	}

	/**
	 * 根据保险公司名称查询保单明细
	 *
	 * @author zhaji
	 * @param CompanyName 保险公司id
	 * @return {@link R<List<  RefundExportListVo  >>}
	 */
	@Operation(summary = "根据保险公司名称查询保单明细", description = "根据保险公司名称查询保单明细")
	@GetMapping("/selectByCompanyName")
	public R selectByCompanyName(String CompanyName) {
		return tInsuranceDetailService.selectByCompanyName(CompanyName);
	}

	/**
	 * 根据险种名称查询保单明细
	 *
	 * @author zhaji
	 * @param id 险种id
	 * @return {@link R<List<  RefundExportListVo  >>}
	 */
	@Operation(summary = "根据险种名称查询保单明细", description = "根据险种名称查询保单明细")
	@GetMapping("/selectByTypeId")
	public R selectByTypeName(String id) {
		return tInsuranceDetailService.selectByTypeId(id);
	}

	/**
	 * 出险
	 *
	 * @author zhaji
	 * @param id 保单id
	 * @return {@link R<List<  RefundExportListVo  >>}
	 */
	@Operation(summary = "出险", description = "出险")
	@GetMapping("/updateIsUse")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insured_edit')")
	public R updateIsUse(String id) {
		return tInsuranceDetailService.updateIsUse(id);
	}


	/**
	 * 查询项目列表
	 *
	 * @author zhaji
	 * @return {@link R<List<Dept>>}
	 */
	@Operation(summary = "查询项目列表", description = "查询项目列表")
	@GetMapping("/deptList")
	public R getDeptList(){
		return tInsuranceDetailService.getDeptList();
	}

	/**
	 * 根据登录人获取项目列表
	 *
	 * @author zhaji
	 * @return {@link R<List<Dept>>}
	 */
	@Operation(summary = "根据登录人获取项目列表", description = "根据登录人获取项目列表")
	@GetMapping("/getDeptListByUser")
	public R getDeptListByUser() {
		return tInsuranceDetailService.getDeptListByUser();
	}

	/**
	 * 紧急出险
	 *
	 * @author zhaji
	 * @param empIdcardNo 身份证
	 * @return {@link R<List<  RefundExportListVo  >>}
	 */
	@Operation(summary = "紧急出险", description = "紧急出险")
	@PostMapping("/urgentUpdateIsUse")
	public R urgentUpdateIsUse(String empIdcardNo) {
		return tInsuranceDetailService.urgentUpdateIsUse(empIdcardNo);
	}

	/**
	 * 紧急出险(20221128需求，ekp调用)
	 *
	 * @author licancan
	 * @param paramList 商险明细id集合
	 * @return {@link R}
	 */
	@Operation(summary = "紧急出险", description = "紧急出险")
	@PostMapping("/urgentUpdateIsUseByIds")
	public R urgentUpdateIsUseByIds(@RequestBody @Valid @Size(min = 1,message = "主键集合不能为空") List<String> paramList) {
		return tInsuranceDetailService.urgentUpdateIsUseByIds(paramList);
	}

	/**
	 * 根据身份证查询所有的商险列表
	 *
	 * @author huyc
	 * @return
	 */
	@Operation(summary = "根据身份证查询所有的商险列表", description = "根据身份证查询所有的商险列表")
	@GetMapping("/getInsuranceListByIdCard")
	public R<IPage<InsuranceListByIdCardVo>> getInsuranceListByIdCard(Page page, String idCard,String deptNo) {
		return new R<>(tInsuranceDetailService.getInsuranceListByIdCard(page, idCard,deptNo));
	}

	/**
	 * 订单商险新增
	 *
	 * @author zhaji
	 * @param paramList
	 * @return {@link R<List<InsuranceAddParam>>}
	 */
	@Operation(summary = "订单商险新增", description = "订单商险新增")
	@PostMapping("/addOrderInsurance")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insure_add')")
	public R<List<InsuranceAddParam>> addOrderInsurance(@RequestBody InsuranceListOrderParam paramList ){
		return tInsuranceDetailService.addOrderInsurance(paramList);
	}

	/**
	 * 订单商险批增
	 *
	 * @author zhaji
	 * @param paramList
	 * @return {@link R<List<InsuranceBatchParam>>}
	 */
	@Operation(summary = "订单商险批增", description = "订单商险批增")
	@PostMapping("/batchOrderInsurance")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insure_batch_add')")
	public R<List<InsuranceBatchParam>> batchOrderInsurance(@RequestBody InsuranceOrderBatchParam paramList){
		return tInsuranceDetailService.batchOrderInsurance(paramList);
	}

	/**
	 * 订单商险替换
	 *
	 * @author zhaji
	 * @param paramList
	 * @return {@link R<List<InsuranceReplaceParam>>}
	 */
	@Operation(summary = "订单商险替换", description = "订单商险替换")
	@PostMapping("/replaceOrderInsurance")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insure_update')")
	public R<List<InsuranceReplaceParam>> replaceOrderInsurance(@RequestBody InsuranceOrderReplaceParam paramList){
		return tInsuranceDetailService.replaceOrderInsurance(paramList);
	}

	/**
	 * 订单商险减员
	 * @param paramList 订单商险减员
	 * @author zhaji
	 * @date 2022-07-19
	 * @since v1.0
	 */
	@PostMapping("/refundOrderInsurance")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_insured_reduce')")
	public R refundOrderInsurance(@RequestBody InsuranceOrderRefundParam paramList){
		return tInsuranceDetailService.refundOrderInsurance(paramList);
	}

	/**
	 * 订单商险列表查询
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param param 查询条件
	 * @return {@link R<IPage<InsuredListVo>>}
	 */
	@Operation(summary = "订单商险列表查询", description = "订单商险列表查询")
	@PostMapping("/getOrderInsuredListPage")
	public R getOrderInsuredListPage(Page<InsuredOrderListVo> page, @RequestBody InsuredOrderParam param) {
		return tInsuranceDetailService.getOrderInsuredListPage(page,param);
	}

	/**
	 * @param changeDeptVo
	 * @Description: ekp费用划转，商险划转项目
	 * @Author: hgw
	 * @Date: 2022/11/17 10:56
	 * @return: void
	 **/
	@Operation(summary = "ekp费用划转，商险划转项目", description = "ekp费用划转，商险划转项目")
	@Inner
	@PostMapping("/inner/ekpUpdateInsuranceDept")
	public void ekpUpdateInsuranceDept(@RequestBody ChangeDeptVo changeDeptVo) {
		tInsuranceDetailService.ekpUpdateInsuranceDept(changeDeptVo);
	}

	/**
	 * 更新收款状态--EKP调用接口
	 * @author  hyc
	 * @param vo
	 * @return R
	 */
	@Operation(summary = "更新商险收款状态--EKP调用接口", description = "更新商险收款状态--EKP调用接口")
	@SysLog("更新商险收款状态--EKP调用接口")
	@PostMapping("/updateInsuranceSettleStatus")
	public R updateInsuranceSettleStatus(@RequestBody EkpStatusParamVo vo) {
		return tInsuranceDetailService.updateInsuranceSettleStatus(vo);
	}

	/**
	 * 更新社保收款状态--EKP调用接口
	 * @author  hyc
	 * @param vo
	 * @return R
	 */
	@Operation(summary = "更新社保收款状态--EKP调用接口", description = "更新社保收款状态--EKP调用接口")
	@SysLog("更新社保收款状态--EKP调用接口")
	@PostMapping("/updateSocialSettleStatus")
	public R updateSocialSettleStatus(@RequestBody EkpStatusParamVo vo) {
		return tInsuranceDetailService.updateSocialSettleStatus(vo);
	}

	/**
	 * 更新收入收款状态--EKP调用接口
	 * @author  hyc
	 * @param vo
	 * @return R
	 */
	@Operation(summary = "更新收入收款状态--EKP调用接口", description = "更新收入收款状态--EKP调用接口")
	@SysLog("更新收入收款状态--EKP调用接口")
	@PostMapping("/updateIncomeSettleStatus")
	public R updateIncomeSettleStatus(@RequestBody EkpStatusParamVo vo) {
		return tInsuranceDetailService.updateIncomeSettleStatus(vo);
	}

	/**
	 * 更新薪资收款状态--EKP调用接口
	 * @author  hyc
	 * @param vo
	 * @return R
	 */
	@Operation(summary = "更新薪资收款状态--EKP调用接口", description = "更新薪资收款状态--EKP调用接口")
	@SysLog("更新薪资收款状态--EKP调用接口")
	@PostMapping("/updateSalarySettleStatus")
	public R updateSalarySettleStatus(@RequestBody EkpStatusParamVo vo) {
		return tInsuranceDetailService.updateSalarySettleStatus(vo);
	}

	/**
	 * 重新更新结算状态同步失败的数据
	 *
	 * @author licancan
	 * @param
	 * @return void
	 */
	@SysLog("重新更新结算状态同步失败的数据")
	@Inner
	@PostMapping("/inner/updateSettleStatus")
	public void updateSettleStatus() {
		tInsuranceDetailService.updateSettleStatus();
	}

	/**
	 * @Description: 获取商险是否在保
	 * @Author: hgw
	 * @Date: 2025/1/14 9:56
	 * @return: com.yifu.cloud.plus.v1.yifu.salary.vo.SalaryRiskListVo
	 **/
	@SysLog("获取商险是否在保")
	@Inner
	@PostMapping("/inner/getRiskByIdCard")
	public SalaryRiskListVo getRiskByIdCard(@RequestBody List<TSalaryAccount> idCardList) {
		return tInsuranceDetailService.getRiskByIdCard(idCardList);
	}

}
