package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceType;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceTypeService;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsuranceTypeVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author zhaji
 * @description 险种相关
 * @date 2022-07-18 17:41:08
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/insuranceType")
@Tag(name = "险种相关")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class TInsuranceTypeController {
	@Resource
	private TInsuranceTypeService insuranceTypeService;

	/**
	 * 分页查询
	 * @param page 分页对象
	 * @param insuranceType 险种
	 * @return
	 */
	@Operation(summary = "分页查询", description = "分页查询")
	@GetMapping("/page" )
	public R<IPage<InsuranceTypeVo>> getInsuranceTypePage(Page<InsuranceTypeVo> page,InsuranceTypeVo insuranceType) {
		return R.ok(insuranceTypeService.pageDiy(page, insuranceType));
	}

	/**
	 * 导出查询
	 * @param insuranceType 险种
	 * @return
	 */
	@Operation(summary = "导出查询", description = "导出查询")
	@PostMapping("/export" )
	public R exportInsuranceType(@RequestBody InsuranceTypeVo insuranceType) {
		return insuranceTypeService.selectInsuranceType(insuranceType);
	}

	/**
	 * 新增险种
	 * @param insuranceType 险种明细
	 * @return R
	 */
	@Operation(summary = "新增险种", description = "新增险种：hasPermission('insurance:insuranceType_save')")
	@SysLog("新增险种")
	@PostMapping("/save")
	@PreAuthorize("@pms.hasPermission('insuranceType_add')")
	public R save(@RequestBody TInsuranceType insuranceType) {
		return insuranceTypeService.saveInsuranceType(insuranceType);
	}

	/**
	 * 通过id查询险种详情
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询险种详情", description = "通过id查询：hasPermission('insurance:insuranceType_getInsuranceTypeDetail')")
	@GetMapping("/{id}" )
	//@PreAuthorize("@pms.hasPermission('insurance:insuranceType_getInsuranceTypeDetail')")
	public R getInsuranceTypeDetail(@PathVariable("id" ) String id) {
		return insuranceTypeService.getInsuranceTypeDetail(id);
	}


	/**
	 * 修改险种
	 * @param insuranceType 险种明细
	 * @return R
	 */
	@Operation(summary = "修改险种", description = "新增险种：hasPermission('insurance:insuranceType_update')")
	@SysLog("修改险种")
	@PostMapping("/update")
	//@PreAuthorize("@pms.hasPermission('insurance:insuranceType_update')")
	public R update(@RequestBody TInsuranceType insuranceType) {
		return insuranceTypeService.updateInsuranceType(insuranceType);
	}

	/**
	 * 查询险种列表
	 * @param insuranceType 险种信息
	 * @return
	 */
	@Operation(summary = "查询险种列表", description = "查询险种列表")
	@PostMapping("/list" )
	public R getInsuranceTypeList(@RequestBody TInsuranceType insuranceType) {
		return insuranceTypeService.getInsuranceTypeList(insuranceType);
	}


	/**
	 * @Author fxj
	 * @Description 更新启用禁用状态
	 * @param id 购买险种id
	 * @param enable 启用禁用状态
	 * @Date 19:00 2025/4/7
	 **/
	@Operation(summary = "通过id更新启用状态", description = "通过id更新启用状态")
	@GetMapping("/enableById" )
	public R enableById(@RequestParam(value = "id",required = true ) String id,
						@RequestParam(value = "enable",required = true ) String enable) {
		return insuranceTypeService.enableById(id,enable);
	}
}
