package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.constants.InsurancesConstants;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.*;
import com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances.TInsuranceTypeMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceCompanyService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceOperateService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceTypeService;
import com.yifu.cloud.plus.v1.yifu.insurances.util.ValidityUtil;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsuranceTypeVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
* @author Administrator
* @description 针对表【t_insurance_type(险种表)】的数据库操作Service实现
* @createDate 2022-07-18 17:19:23
*/
@Service
public class TInsuranceTypeServiceImpl extends ServiceImpl<TInsuranceTypeMapper, TInsuranceType> implements TInsuranceTypeService {

	@Resource
	private TInsuranceCompanyService tInsuranceCompanyService;

	@Resource
	private TInsuranceOperateService tInsuranceOperateService;

	/**
	 * 险种分页查询
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param insuranceType 分页查询参数
	 * @return {@link IPage<InsuranceTypeVo>}
	 */
	@Override
	public IPage<InsuranceTypeVo> pageDiy(Page<InsuranceTypeVo> page, InsuranceTypeVo insuranceType) {
		return this.baseMapper.selectInsuranceTypePage(page,insuranceType);
	}

	/**
	 * 险种批量导出
	 * @author huych
	 * @param insuranceType 查询参数
	 */
	@Override
	public R selectInsuranceType(InsuranceTypeVo insuranceType) {
		return R.ok(baseMapper.selectInsuranceType(insuranceType));
	}

	/**
	 * 新增险种信息
	 *
	 * @author zhaji
	 * @param insuranceType 新增险种信息
	 * @return {@link R}
	 */
	@Override
	@Transactional(value = "insurancesTransactionManager" ,rollbackFor = {Exception.class})
	public R saveInsuranceType(TInsuranceType insuranceType) {
		if(Common.isEmpty(insuranceType)){
			return R.failed("新增的险种信息为空");
		}
		YifuUser user = SecurityUtils.getUser();
		String companyId = insuranceType.getInsuranceCompanyId();
		String bankNo = insuranceType.getBankNo();
		String bankName = insuranceType.getBankName();
		String receiptUnitName = insuranceType.getReceiptUnitName();
		if (!ValidityUtil.validate50(insuranceType.getName())){
			return R.failed("险种格式不正确");
		}
		if(!ValidityUtil.validatePositiveInt(bankNo) || !ValidityUtil.validate50(bankNo)){
			return R.failed("银行账号格式不正确");
		}
		if(!ValidityUtil.validate50(bankName)){
			return R.failed("收款银行格式不正确");
		}
		if(!ValidityUtil.validate50(receiptUnitName)){
			return R.failed("收款单位名称格式不正确");
		}
		LambdaQueryWrapper<TInsuranceCompany> companyWrapper = new LambdaQueryWrapper<>();
		companyWrapper.eq(TInsuranceCompany::getId,companyId).eq(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT);
		TInsuranceCompany insuranceCompany = tInsuranceCompanyService.getOne(companyWrapper);
		if(Common.isEmpty(insuranceCompany)){
			return R.failed("所属保险公司不存在或已被删除");
		}
		LambdaQueryWrapper<TInsuranceType> typeWrapper = new LambdaQueryWrapper<>();
		typeWrapper.eq(TInsuranceType :: getInsuranceCompanyId ,companyId)
				.eq(TInsuranceType::getName,insuranceType.getName())
				.eq(TInsuranceType::getDeleteFlag, CommonConstants.ZERO_INT);
		TInsuranceType type = getOne(typeWrapper);
		if (!Common.isEmpty(type)){
			return R.failed("当前保险公司已存在该险种");
		}else{
			insuranceType.setDeleteFlag(CommonConstants.ZERO_INT);
			insuranceType.setCreateBy(user.getId());
			insuranceType.setCreateName(user.getNickname());
			insuranceType.setCreateTime(LocalDateTime.now());
			save(insuranceType);
			addOperate(insuranceType,user, InsurancesConstants.NEW_INSURANCE_TYPE);
			return R.ok("新增险种信息成功");
		}
	}

	/**
	 * 查看险种详情
	 *
	 * @author zhaji
	 * @param id 险种id
	 * @return {@link InsuranceTypeVo}
	 */
	@Override
	public R getInsuranceTypeDetail(String id) {
		if (Common.isEmpty(id)){
			return R.failed("险种ID不能为空");
		}
		InsuranceTypeVo insuranceTypeVo = this.baseMapper.getInsuranceTypeDetailById(id);
		if(Common.isEmpty(insuranceTypeVo)){
			return R.failed("当前险种信息不存在或已被删除");
		}
		List<TInsuranceTypeRate> tInsuranceTypeRates = this.baseMapper.selectInsuranceTypeRateList(id);
		List<TInsuranceTypeStandard> tInsuranceTypeStandards = this.baseMapper.selectInsuranceTypeStandardList(id);
		insuranceTypeVo.setInsuranceTypeRateList(tInsuranceTypeRates);
		insuranceTypeVo.setInsuranceTypeStandardList(tInsuranceTypeStandards);
		return R.ok(insuranceTypeVo);
	}

	/**
	 * 修改险种信息
	 *
	 * @author zhaji
	 * @param insuranceType 险种信息
	 * @return {@link R}
	 */
	@Override
	@Transactional(value = "insurancesTransactionManager" ,rollbackFor = {Exception.class})
	public R updateInsuranceType(TInsuranceType insuranceType) {
		YifuUser user = SecurityUtils.getUser();
		if (Common.isEmpty(insuranceType.getId())){
			return R.failed("险种ID不能为空");
		}
		TInsuranceType byId = getById(insuranceType.getId());
		if(Common.isEmpty(byId) || byId.getDeleteFlag() == CommonConstants.ONE_INT){
			return R.failed("当前险种信息不存在或已被删除");
		}
		if(byId.getName().equals(insuranceType.getName())){
			insuranceType.setUpdateBy(user.getId());
			insuranceType.setUpdateTime(LocalDateTime.now());
			updateById(insuranceType);
			addOperate(insuranceType,user, InsurancesConstants.UPDATE_INSURANCE_TYPE);
			return R.ok("修改险种信息成功");
		}else{
			LambdaQueryWrapper<TInsuranceType> queryWrapper = new LambdaQueryWrapper<>();
			queryWrapper.eq(TInsuranceType::getName,insuranceType.getName())
					.eq(TInsuranceType::getInsuranceCompanyId,insuranceType.getInsuranceCompanyId())
					.eq(TInsuranceType::getDeleteFlag,CommonConstants.ZERO_INT);
			TInsuranceType one = this.getOne(queryWrapper);
			if (Common.isEmpty(one)){
				insuranceType.setUpdateBy(user.getId());
				insuranceType.setUpdateTime(LocalDateTime.now());
				updateById(insuranceType);
				addOperate(insuranceType,user, InsurancesConstants.UPDATE_INSURANCE_TYPE);
				return R.ok("修改险种信息成功");
			}else{
				return R.failed("当前险种名称已存在");
			}
		}
	}

	/**
	 * 操作记录
	 *
	 * @author zhaji
	 * @param insuranceType 险种信息
	 * @param user 登录用户
	 * @param operateDesc 操作描述
	 * @return void
	 */
	private void addOperate(TInsuranceType insuranceType,YifuUser user,String operateDesc){
		try {
			TInsuranceOperate operate = new TInsuranceOperate();
			operate.setInsuranceDetailId(insuranceType.getId());
			operate.setOperateDesc(operateDesc);
			operate.setCreateBy(user.getId());
			operate.setCreateName(user.getNickname());
			operate.setCreateTime(LocalDateTime.now());
			tInsuranceOperateService.save(operate);
		}catch (Exception e){
			e.getStackTrace();
		}
	}

	/**
	 * 查询险种列表
	 *
	 * @author zhaji
	 * @param insuranceType 险种信息
	 * @return {@link List< TInsuranceType>}
	 */
	@Override
	public R getInsuranceTypeList(TInsuranceType insuranceType) {
		String companyId = insuranceType.getInsuranceCompanyId();
		LambdaQueryWrapper<TInsuranceType> query = new LambdaQueryWrapper<>();
		query.eq(TInsuranceType::getDeleteFlag,CommonConstants.ZERO_INT);

		if(StringUtils.isBlank(companyId)){
			List<TInsuranceType> list = this.list(query);
			return R.ok(list,"查询险种列表成功");
		}else{
			LambdaQueryWrapper<TInsuranceCompany> companyWrapper = new LambdaQueryWrapper<>();
			companyWrapper.eq(TInsuranceCompany::getId,companyId).eq(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT);
			TInsuranceCompany insuranceCompany = tInsuranceCompanyService.getOne(companyWrapper);
			if(Common.isEmpty(insuranceCompany)){
				return R.failed("所属保险公司不存在或已被删除");
			}else{
				query.eq(TInsuranceType::getInsuranceCompanyId,companyId);
				List<TInsuranceType> list = this.list(query);
				return R.ok(list,"查询险种列表成功");
			}
		}
	}

	@Override
	@Transactional(value = "insurancesTransactionEnableByIdr" ,rollbackFor = {Exception.class})
	public R enableById(String id, String enable) {
		if (Common.isEmpty(id)
				|| Common.isEmpty(enable)
				|| !CommonConstants.ONE_STRING.equals(enable)
				&& !CommonConstants.TWO_STRING.equals(enable)){
			return R.failed(CommonConstants.PARAM_IS_NOT_ERROR);
		}
		TInsuranceType insuranceType = getById(id);
		if (Common.isEmpty(insuranceType)){
			return R.failed("当前险种信息不存在或已被删除");
		}
		insuranceType.setEnable(enable);
		baseMapper.updateById(insuranceType);
		return R.ok();
	}

}
