package com.yifu.cloud.plus.v1.yifu.process.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.process.entity.TNodeRoute;

/**
 * 流程路由表（节点与节点之间的路由关系）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
public interface TNodeRouteService extends IService<TNodeRoute> {

     /**
      * 流程路由表（节点与节点之间的路由关系）简单分页查询
      *
      * @param tNodeRoute 流程路由表（节点与节点之间的路由关系）
      * @return
      */
     IPage<TNodeRoute> getTNodeRoutePage(Page<TNodeRoute> page, TNodeRoute tNodeRoute);

     /**
      * @param processId 流程id
      * @Description: 根据id删除节点
      * @Author: hgw
      * @Date: 2020/7/17 11:19
      * @return: int
      **/
     int deleteByProcessId(String processId);

}
