package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;


/**
 * 最低工资提醒-临时人员连续购买最低工资次数
 *
 * @author wangan
 * @date 2020-12-17 09:23:30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("sys_message_salary_temp")
@Tag(name = "最低工资提醒-临时人员连续购买最低工资次数")
public class SysMessageSalaryTemp extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     *
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "")
    private String id;
    /**
     * 最低工资表数据id
     */
    @Length(max = 32, message = "最低工资表数据id 不能超过32个字符")
    @ExcelAttribute(name = "最低工资表数据id ", maxLength = 32)
    @Schema(description = "最低工资表数据id ", name = "relateId")
    private String relateId;
    /**
     * 次数
     */
    @ExcelAttribute(name = "次数")
    @Schema(description = "次数", name = "times")
    private Integer times;

    /**
     * 结算月
     */
    @Length(max = 10, message = "结算月不能超过10个字符")
    @ExcelAttribute(name = "结算月", maxLength = 10, needExport = true)
    @Schema(description = "结算月", name = "settleMonth")
    private String settleMonth;
}
