package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 工资报账主表（工资条）VO
 *
 * @author hgw
 * @date 2019-07-30 15:00:05
 */
@Data
public class TSalaryAccountVo implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 封面抬头
	 */
	@Length(max = 50, message = "封面抬头不能超过50个字符")
	@ExcelAttribute(name = "封面抬头", maxLength = 50)
	private String invoiceTitle;

	/**
	 * 工资表ID
	 */
	@Length(max = 32, message = "工资表ID不能超过32个字符")
	@NotBlank(message = "工资表ID不能为空")
	@ExcelAttribute(name = "工资表ID", maxLength = 32)
	private String salaryFormId;
	/**
	 * 薪酬月份
	 */
	@ExcelAttribute(name = "薪酬月份", isNotEmpty = true, errorInfo = "薪酬月份不能为空", maxLength = 6)
	@NotBlank(message = "薪酬月份不能为空")
	@Length(max = 6, message = "薪酬月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("薪酬月份")
	private String salaryMonth;
	/**
	 * 员工 ID
	 */
	@Length(max = 32, message = "员工 ID不能超过32个字符")
	@NotBlank(message = "员工 ID不能为空")
	@ExcelAttribute(name = "员工 ID", isNotEmpty = true, errorInfo = "员工 ID不能为空", maxLength = 32)
	private String empId;
	/**
	 * 员工姓名
	 */
	@Length(max = 50, message = "员工姓名不能超过50个字符")
	@NotBlank(message = "员工姓名不能为空")
	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	private String empName;

	/**
	 * 银行卡号000
	 */
	@Length(max = 50, message = "银行卡号不能超过50个字符")
	@ExcelAttribute(name = "银行卡号", maxLength = 50)
	private String bankNo;
	/**
	 * 开户行总行
	 */
	@ExcelAttribute(name = "开户行总行", maxLength = 50)
	@Length(max = 50, message = "开户行总行不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行总行")
	private String bankName;

	/**
	 * 项目id
	 */
	@ExcelAttribute(name = "项目id", isNotEmpty = true, errorInfo = "项目id不能为空", maxLength = 32)
	@NotBlank(message = "项目id不能为空")
	@Length(max = 32, message = "项目id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目id")
	private String deptId;
	/**
	 * 项目no
	 */
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目no不能为空", maxLength = 50)
	@NotBlank(message = "项目编码不能为空")
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 项目name
	 */
	@ExcelAttribute(name = "项目名称", isNotEmpty = true, errorInfo = "项目name不能为空", maxLength = 50)
	@NotBlank(message = "项目名称不能为空")
	@Length(max = 50, message = "项目名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;

	/**
	 * 客户ID
	 */
	@ExcelAttribute(name = "客户ID", isNotEmpty = true, errorInfo = "客户ID不能为空", maxLength = 32)
	@NotBlank(message = "客户ID不能为空")
	@Length(max = 32, message = "客户ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户ID")
	private String unitId;
	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", isNotEmpty = true, errorInfo = "客户名称不能为空", maxLength = 50)
	@NotBlank(message = "客户名称不能为空")
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String unitName;
	/**
	 * 客户编码
	 */
	@ExcelAttribute(name = "客户编码", maxLength = 32)
	@Length(max = 32, message = "客户编码不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户编码")
	private String unitNo;

	/**
	 * 身份证号
	 */
	@Length(max = 18, message = "身份证号不能超过18个字符")
	@NotBlank(message = "身份证号不能为空")
	@ExcelAttribute(name = "身份证号", maxLength = 18)
	private String empIdcard;

	/**
	 * 工资发放方式（0现金/1银行）/2线下000
	 */
	@NotBlank(message = "工资发放方式（0现金/1银行）/2线下不能为空")
	@ExcelAttribute(name = "工资发放方式（0现金/1银行）/2线下", isNotEmpty = true, errorInfo = "工资发放方式（0现金/1银行）/2线下不能为空")
	private String salaryStyle;
	/**
	 * 工资发放时间（0立即发、1暂停发）000
	 */
	@NotBlank(message = "工资发放时间（0立即发、1暂停发）不能为空")
	@ExcelAttribute(name = "工资发放时间（0立即发、1暂停发）", isNotEmpty = true, errorInfo = "工资发放时间（0立即发、1暂停发）不能为空")
	private String salaryGiveTime;
	/**
	 * 发放状态 0: 未发放 1: 发放成功 2:发放失败
	 */
	@NotBlank(message = "发放状态 0: 未发放 1: 发放成功 2:发放失败不能为空")
	@ExcelAttribute(name = "发放状态 0: 未发放 1: 发放成功 2:发放失败", isNotEmpty = true, errorInfo = "发放状态 0: 未发放 1: 发放成功 2:发放失败不能为空")
	private String distributionFlag;
	/**
	 * 社保扣缴月份000
	 */
	@Length(max = 6, message = "社保扣缴月份不能超过6个字符")
	@ExcelAttribute(name = "社保扣缴月份", maxLength = 6)
	private String deduSocialMonth;
	/**
	 * 公积金扣缴月份000
	 */
	@Length(max = 6, message = "公积金扣缴月份不能超过6个字符")
	@ExcelAttribute(name = "公积金扣缴月份", maxLength = 6)
	private String deduProvidentMonth;
	/**
	 * 报表类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬
	 */
	@ExcelAttribute(name = "报表类型", readConverterExp = "0=薪资,1=绩效,2=其他,3=劳务费,4=稿酬")
	@NotBlank(message = "报表类型不能为空")
	@Length(max = 32, message = "报表类型不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("报表类型")
	private String formType;

	/**
	 * 结算月
	 */
	@Length(max = 6, message = "结算月份不能超过6个字符")
	@NotBlank(message = "结算月份不能为空")
	@ExcelAttribute(name = "结算月份", isNotEmpty = true, errorInfo = "结算月份不能为空", maxLength = 6)
	private String settlementMonth;

	/**
	 * @Description: 是否删除0：未删除；1:已删除
	 * @Author: hgw
	 * @Date: 2019/8/30 18:20
	 * @return:
	 **/
	@Length(max = 1, message = "是否删除不能超过1个字符")
	@NotBlank(message = "是否删除不能为空")
	@ExcelAttribute(name = "是否删除", isNotEmpty = true, errorInfo = "是否删除不能为空", maxLength = 1)
	private Integer deleteFlag;  //0：未删除； 1：已删除

	/**
	 * 社保优先级0：生成月；1：缴纳月000
	 */
	@NotBlank(message = "社保优先级0：生成月；1：缴纳月不能为空")
	@Length(max = 1, message = "社保优先级0：生成月；1：缴纳月不能超过1个字符")
	@ExcelAttribute(name = "社保优先级0：生成月；1：缴纳月", isNotEmpty = true, errorInfo = "社保优先级0：生成月；1：缴纳月不能为空", maxLength = 1)
	private String socialPriority;
	/**
	 * 公积金优先级0：生成月；1：缴纳月000
	 */
	@NotBlank(message = "公积金优先级0：生成月；1：缴纳月不能为空")
	@Length(max = 1, message = "公积金优先级0：生成月；1：缴纳月不能超过1个字符")
	@ExcelAttribute(name = "公积金优先级0：生成月；1：缴纳月", isNotEmpty = true, errorInfo = "公积金优先级0：生成月；1：缴纳月不能为空", maxLength = 1)
	private String fundPriority;
	/**
	 * 年终奖扣税方案0：合并；1：单独000
	 */
	@NotBlank(message = "年终奖扣税方案0：合并；1：单独不能为空")
	@Length(max = 1, message = "年终奖扣税方案0：合并；1：单独不能超过1个字符")
	@ExcelAttribute(name = "年终奖扣税方案0：合并；1：单独", isNotEmpty = true, errorInfo = "年终奖扣税方案0：合并；1：单独不能为空", maxLength = 1)
	private String annualBonusType;

	/**
	 * 计税月份
	 */
	@Length(max = 32, message = "计税月份不能超过6个字符")
	@ExcelAttribute(name = "计税月份", maxLength = 6)
	private String taxMonth;

	//000
	@ExcelAttribute(name = "是否扣除社保 0:否,1:是", maxLength = 1)
	private String isDeductSocial;

	//000
	@ExcelAttribute(name = "是否扣除公积金 0:否,1:是", maxLength = 1)
	private String isDeductFund;

	/**
	 * 省
	 */
	@Length(max = 32, message = "省不能超过32个字符")
	@ExcelAttribute(name = "省", maxLength = 32, isDataId = true, isArea = true, parentField = "")
	private Integer province;
	/**
	 * 市
	 */
	@Length(max = 32, message = "市不能超过32个字符")
	@ExcelAttribute(name = "市", maxLength = 32, isDataId = true, isArea = true, parentField = "province")
	private Integer city;
	/**
	 * 县
	 */
	@Length(max = 32, message = "县不能超过32个字符")
	@ExcelAttribute(name = "县", maxLength = 32, isDataId = true, isArea = true, parentField = "city")
	private Integer town;

	/**
	 * 手机号
	 */
	@ExcelAttribute(name = "手机号码", maxLength = 11)
	private String empPhone;

	/**
	 * 是否自有员工：默认0:否；1:是自有员工
	 */
	@Length(max = 1, message = "是否自有员工不能超过1个字符")
	@ExcelAttribute(name = "是否自有员工", maxLength = 1)
	private Integer ownFlag;

	@Schema(description = "劳务费、稿酬是否含有发薪0：否；1：是")
	@ExcelAttribute(name = "劳务费、稿酬是否含有发薪")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("劳务费、稿酬是否含有发薪")
	private Integer haveSalaryFlag;

	@Schema(description = "是否含有特殊金额0：否；1：是")
	@ExcelAttribute(name = "是否含有特殊金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否含有特殊金额")
	private Integer haveSpecialFlag;

	/**
	 * 本月是否重复金额0：否；1：是重复导入的
	 */
	@Length(max = 1, message = "本月是否重复金额不能超过1个字符")
	@ExcelAttribute(name = "本月是否重复金额", maxLength = 1)
	private Integer isRepeat;

	/**
	 * 开户行支行
	 */
	@ExcelAttribute(name = "开户行支行", maxLength = 50)
	@Length(max = 50, message = "开户行支行不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行支行")
	private String bankSubName;
	/**
	 * 开户行省
	 */
	@ExcelAttribute(name = "开户行省", isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行省")
	private String bankProvince;
	/**
	 * 开户行市
	 */
	@ExcelAttribute(name = "开户行市", isArea = true, parentField = "bankProvince")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行市")
	private String bankCity;

	/**
	 * 是否个人承担部分税费
	 * 公司承担全部税费0
	 * 个人承担部分税费1
	 * 个人承担全部税费2
	 */
	@ExcelAttribute(name = "是否个人承担部分税费", maxLength = 8)
	@Length(max = 8, message = "是否个人承担部分税费：0否1是2全不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否个人承担部分税费")
	private String isPersonTax;
	/**
	 * 应发薪酬（劳务费、稿酬）
	 */
	@ExcelAttribute(name = "应发薪酬")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("应发薪酬")
	private BigDecimal relaySalary;
	/**
	 * 实发（个人实收）
	 */
	@ExcelAttribute(name = "实发（个人实收）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("实发（个人实收）")
	private BigDecimal actualSalary;
	/**
	 * 个税金额（个人承担）
	 */
	@ExcelAttribute(name = "个税金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个税金额")
	private BigDecimal salaryTax;
	/**
	 * 公司应发
	 */
	@ExcelAttribute(name = "公司应发")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公司应发")
	private BigDecimal relaySalaryUnit;
	/**
	 * 个税-单位承担
	 */
	@ExcelAttribute(name = "个税-单位承担")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个税-单位承担")
	private BigDecimal salaryTaxUnit;

	@ExcelAttribute(name = "是否新员工（默认否）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否新员工（默认否）")
	private String isNewEmployee;

	/**
	 * 通讯补贴（不计税）
	 */
	@ExcelAttribute(name = "通讯补贴（不计税）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("通讯补贴（不计税）")
	private BigDecimal phoneSubsidy;

	private List<TSalaryAccountItemVo> saiList = new ArrayList<>();  //工资组成部分明细
}
