/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 薪资人员档案变更记录
 *
 * @author fxj
 * @date 2023-10-11 17:48:31
 */
@Data
public class TSalaryEmpModLogVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@ExcelProperty("id")
	private String id;
	/**
	 * content
	 */
	@Length(max = 50, message = "content 不能超过50 个字符")
	@ExcelAttribute(name = "content", maxLength = 50)
	@Schema(description = "content")
	@ExcelProperty("content")
	private String content;
	/**
	 * 0编辑、1批量更新、2EKP变更银行卡号
	 */
	@NotBlank(message = "0编辑、1批量更新、2EKP变更银行卡号 不能为空")
	@Length(max = 1, message = "0编辑、1批量更新、2EKP变更银行卡号 不能超过1 个字符")
	@ExcelAttribute(name = "0编辑、1批量更新、2EKP变更银行卡号", isNotEmpty = true, errorInfo = "0编辑、1批量更新、2EKP变更银行卡号 不能为空", maxLength = 1)
	@Schema(description = "0编辑、1批量更新、2EKP变更银行卡号")
	@ExcelProperty("0编辑、1批量更新、2EKP变更银行卡号")
	private String type;
	/**
	 * idNum
	 */
	@Length(max = 20, message = "idNum 不能超过20 个字符")
	@ExcelAttribute(name = "idNum", maxLength = 20)
	@Schema(description = "idNum")
	@ExcelProperty("idNum")
	private String idNum;
	/**
	 * parentId
	 */
	@Length(max = 32, message = "parentId 不能超过32 个字符")
	@ExcelAttribute(name = "parentId", maxLength = 32)
	@Schema(description = "parentId")
	@ExcelProperty("parentId")
	private String parentId;

}
