package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccountItem;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardSet;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 工资条VO
 *
 * @author hgw
 * @date 2021-10-8 14:53:35
 */
@Data
@Tag(name = "工资条VO")
public class TSalarySetVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @Schema(description = "工资明细")
    private Set<String> salaryItem = new HashSet<>();

    @Schema(description = "工资条配置，顺序的明细在detailList里")
    private TSalaryStandardSet salarySet = new TSalaryStandardSet();

    @Schema(description = "报账明细")
    private List<TSalaryAccountItem> itemList = new ArrayList<>();

}
