/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TFascHrField;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TFascHrFieldMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TFascHrFieldService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 法大大专业版皖信字段表
 *
 * @author hgw
 * @date 2025-09-30 16:29:27
 */
@Log4j2
@Service
public class TFascHrFieldServiceImpl extends ServiceImpl<TFascHrFieldMapper, TFascHrField> implements TFascHrFieldService {
    /**
     * 法大大专业版皖信字段表简单分页查询
     * @param tFascHrField 法大大专业版皖信字段表
     * @return
     */
    @Override
    public IPage<TFascHrField> getTFascHrFieldPage(Page<TFascHrField> page, TFascHrField tFascHrField){
        return baseMapper.getTFascHrFieldPage(page,tFascHrField);
    }

	@Override
	public List<TFascHrField> noPageDiy(TFascHrField tFascHrField) {
		return baseMapper.getTFascHrFieldList(tFascHrField);
	}

	@Override
	public Map<String, Map<String, String>> getFieldAllMap(TFascHrField tFascHrField) {
		List<TFascHrField> list = baseMapper.getTFascHrFieldList(tFascHrField);
		Map<String, Map<String, String>> contractTypeMap = new HashMap<>();
		Map<String, String> fieldMap;
		if (list != null && !list.isEmpty()) {
			for (TFascHrField f : list) {
				fieldMap = contractTypeMap.get(f.getContractType());
				if (fieldMap == null) {
					fieldMap = new HashMap<>();
				}
				fieldMap.put(f.getHrFieldId() + CommonConstants.DOWN_LINE_STRING + f.getHrField(), f.getId());
				contractTypeMap.put(f.getContractType(), fieldMap);
			}
		}
		return contractTypeMap;
	}

}
