/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * EKP预算预警表
 *
 * @author fxj
 * @date 2025-07-15 11:53:01
 */
@Data
@TableName("ekp_budget_warning_info")
@Schema(description = "EKP预算预警表")
public class EkpBudgetWarningInfo{

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String fdId;
	/**
	 * 预警内容
	 */
	@ExcelAttribute(name = "预警内容", maxLength = 300)
	@Length(max = 300, message = "预警内容不能超过300个字符")
	@ExcelProperty("预警内容")
	@Schema(description = "预警内容")
	private String fdContent;
	/**
	 * 预警时间
	 */
	@ExcelAttribute(name = "预警时间", isDate = true)
	@ExcelProperty("预警时间")
	@Schema(description = "预警时间")
	private Date fdCreateTime;
	/**
	 * 科目
	 */
	@ExcelAttribute(name = "科目", maxLength = 50)
	@Length(max = 50, message = "科目不能超过50个字符")
	@ExcelProperty("科目")
	@Schema(description = "科目")
	private String fdSubject;
	/**
	 * 阅读状态：0未读 1已读
	 */
	@ExcelAttribute(name = "阅读状态：0未读 1已读", maxLength = 10)
	@Length(max = 10, message = "阅读状态：0未读 1已读不能超过10个字符")
	@ExcelProperty("阅读状态：0未读 1已读")
	@Schema(description = "阅读状态：0未读 1已读")
	private String fdReadStatus;
	/**
	 * 接受人姓名
	 */
	@ExcelAttribute(name = "接受人姓名", maxLength = 50)
	@Length(max = 50, message = "接受人姓名不能超过50个字符")
	@ExcelProperty("接受人姓名")
	@Schema(description = "接受人姓名")
	private String fdRecipientName;
	/**
	 * 接收人账号
	 */
	@ExcelAttribute(name = "接收人账号", maxLength = 50)
	@Length(max = 50, message = "接收人账号不能超过50个字符")
	@ExcelProperty("接收人账号")
	@Schema(description = "接收人账号")
	private String fdRecipientAccount;
	/**
	 * 接收人ID(EKP-ID)
	 */
	@ExcelAttribute(name = "接收人ID(EKP-ID)", maxLength = 36)
	@Length(max = 36, message = "接收人ID(EKP-ID)不能超过36个字符")
	@ExcelProperty("接收人ID(EKP-ID)")
	@Schema(description = "接收人ID(EKP-ID)")
	private String fdRecipientId;

}
