/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 薪资工资条配置主表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TSalaryStandardSetVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
	private String id;
	/**
	 * 工资主表ID
	 */
	@NotBlank(message = "工资主表ID 不能为空")
	@Length(max = 32, message = "工资主表ID 不能超过32 个字符")
	@ExcelAttribute(name = "工资主表ID", isNotEmpty = true, errorInfo = "工资主表ID 不能为空", maxLength = 32)
	@Schema(description = "工资主表ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资主表ID")
	private String salaryId;
	/**
	 * 结算部门id
	 */
	@NotBlank(message = "结算部门id 不能为空")
	@Length(max = 32, message = "结算部门id 不能超过32 个字符")
	@ExcelAttribute(name = "结算部门id", isNotEmpty = true, errorInfo = "结算部门id 不能为空", maxLength = 32)
	@Schema(description = "结算部门id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门id")
	private String deptId;

	/**
	 * 是否为0不显示：0显示；1不显示
	 */
	@ExcelAttribute(name = "是否为0不显示：0显示；1不显示")
	@Schema(description = "是否为0不显示：0显示；1不显示")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否为0不显示：0显示；1不显示")
	private Integer isZero;

}
