/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.fasc.open.api.exception.ApiException;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddContractInfo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

/**
 * 法大大合同与员工合同信息
 *
 * @author fxj
 * @date 2022-06-29 16:21:51
 */
public interface FascService extends IService<FddContractInfo> {

	// 获取模板
	R<String> getTemplate(String templateName) throws ApiException;

	// 推送法大大任务
	R<String> submitContract(String id) throws ApiException;

	// 撤销签署任务
	R<String> cancelTask(String id) throws ApiException;

	// 催办签署任务
	R<String> urgeTask(String id) throws ApiException;

}
