/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 工资表-缴费库
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
@TableName("m_salary_estimate")
@Schema(description = "工资表-缴费库")
public class MSalaryEstimate {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 工资表ID
	 */
	@ExcelAttribute(name = "工资表ID", isNotEmpty = true, errorInfo = "工资表ID不能为空", maxLength = 32)
	@NotBlank(message = "工资表ID不能为空")
	@Length(max = 32, message = "工资表ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资表ID")
	private String salaryId;
	/**
	 * 预估库表ID
	 */
	@ExcelAttribute(name = "预估库表ID", isNotEmpty = true, errorInfo = "预估库表ID不能为空", maxLength = 32)
	@NotBlank(message = "预估库表ID不能为空")
	@Length(max = 32, message = "预估库表ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("预估库表ID")
	private String estimateId;
	/**
	 * 类型：0：社保；1：公积金；
	 */
	@ExcelAttribute(name = "类型：0：社保；1：公积金；", isNotEmpty = true, errorInfo = "类型：0：社保；1：公积金；不能为空")
	@NotBlank(message = "类型：0：社保；1：公积金；不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型：0：社保；1：公积金；")
	private Integer isSocial;
	/**
	 * 来源类型：0：缴费库；1：预估库；
	 */
	@ExcelAttribute(name = "来源类型：0：缴费库；1：预估库；", isNotEmpty = true, errorInfo = "来源类型：0：缴费库；1：预估库；不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("来源类型：0：缴费库；1：预估库；")
	private Integer type;
	/**
	 * 类型：0：正常扣缴；1：无工资人员；
	 */
	@ExcelAttribute(name = "类型：0：正常扣缴；1：无工资人员；", isNotEmpty = true, errorInfo = "类型：0：正常扣缴；1：无工资人员；不能为空")
	@NotBlank(message = "类型：0：正常扣缴；1：无工资人员；不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型：0：正常扣缴；1：无工资人员；")
	private Integer isNoSalary;

}
