/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 暂停发表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TPauseSalaryVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 报账表ID
	 */
	@NotBlank(message = "报账表ID 不能为空")
	@Length(max = 32, message = "报账表ID 不能超过32 个字符")
	@ExcelAttribute(name = "报账表ID", isNotEmpty = true, errorInfo = "报账表ID 不能为空", maxLength = 32)
	@Schema(description = "报账表ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("报账表ID")
	private String salaryAccountId;
	/**
	 * 姓名
	 */
	@Length(max = 20, message = "姓名 不能超过20 个字符")
	@ExcelAttribute(name = "姓名", maxLength = 20)
	@Schema(description = "姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("姓名")
	private String name;
	/**
	 * 身份证号
	 */
	@Length(max = 20, message = "身份证号 不能超过20 个字符")
	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String idCard;
	/**
	 * 发放方式（0现金/1银行）/2线下
	 */
	@ExcelAttribute(name = "发放方式（0现金/1银行）/2线下")
	@Schema(description = "发放方式（0现金/1银行）/2线下")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发放方式（0现金/1银行）/2线下")
	private Integer salaryStyle;
	/**
	 * 银行名称
	 */
	@Length(max = 100, message = "银行名称 不能超过100 个字符")
	@ExcelAttribute(name = "银行名称", maxLength = 100)
	@Schema(description = "银行名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("银行名称")
	private String bankName;
	/**
	 * 银行卡号
	 */
	@Length(max = 50, message = "银行卡号 不能超过50 个字符")
	@ExcelAttribute(name = "银行卡号", maxLength = 50)
	@Schema(description = "银行卡号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("银行卡号")
	private String bankNo;
	/**
	 * 剩余工资
	 */
	@ExcelAttribute(name = "剩余工资")
	@Schema(description = "剩余工资")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("剩余工资")
	private BigDecimal balance;
	/**
	 * 拆分发金额
	 */
	@ExcelAttribute(name = "拆分发金额")
	@Schema(description = "拆分发金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("拆分发金额")
	private BigDecimal balanceSpilit;
	/**
	 * 工资日期
	 */
	@Length(max = 10, message = "工资日期 不能超过10 个字符")
	@ExcelAttribute(name = "工资日期", maxLength = 10)
	@Schema(description = "工资日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资日期")
	private String salaryDate;
	/**
	 * 结算日期
	 */
	@Length(max = 10, message = "结算日期 不能超过10 个字符")
	@ExcelAttribute(name = "结算日期", maxLength = 10)
	@Schema(description = "结算日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算日期")
	private String settleDate;

	/**
	 * 工资表ID
	 */
	@NotBlank(message = "工资表ID 不能为空")
	@Length(max = 32, message = "工资表ID 不能超过32 个字符")
	@ExcelAttribute(name = "工资表ID", isNotEmpty = true, errorInfo = "工资表ID 不能为空", maxLength = 32)
	@Schema(description = "工资表ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资表ID")
	private String salaryFormId;
	/**
	 * 所属部门
	 */
	@NotBlank(message = "所属部门 不能为空")
	@Length(max = 32, message = "所属部门 不能超过32 个字符")
	@ExcelAttribute(name = "所属部门", isNotEmpty = true, errorInfo = "所属部门 不能为空", maxLength = 32)
	@Schema(description = "所属部门")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所属部门")
	private String settleDepartId;
	/**
	 * 结算部门
	 */
	@NotBlank(message = "结算部门 不能为空")
	@Length(max = 50, message = "结算部门 不能超过50 个字符")
	@ExcelAttribute(name = "结算部门", isNotEmpty = true, errorInfo = "结算部门 不能为空", maxLength = 50)
	@Schema(description = "结算部门")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门")
	private String settleDepartNo;
	/**
	 * 结算部门
	 */
	@NotBlank(message = "结算部门 不能为空")
	@Length(max = 50, message = "结算部门 不能超过50 个字符")
	@ExcelAttribute(name = "结算部门", isNotEmpty = true, errorInfo = "结算部门 不能为空", maxLength = 50)
	@Schema(description = "结算部门")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门")
	private String settleDepartName;
	/**
	 * 类型0：工资；1：工程工资
	 */
	@ExcelAttribute(name = "类型0：工资；1：工程工资")
	@Schema(description = "类型0：工资；1：工程工资")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型0：工资；1：工程工资")
	private Integer type;
	/**
	 * 收款单位名称
	 */
	@Length(max = 100, message = "收款单位名称 不能超过100 个字符")
	@ExcelAttribute(name = "收款单位名称", maxLength = 100)
	@Schema(description = "收款单位名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收款单位名称")
	private String organNameOne;
	/**
	 * 收款单位名称
	 */
	@Length(max = 100, message = "收款单位名称 不能超过100 个字符")
	@ExcelAttribute(name = "收款单位名称", maxLength = 100)
	@Schema(description = "收款单位名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收款单位名称")
	private String organNameTwo;
	/**
	 * 开户行
	 */
	@Length(max = 100, message = "开户行 不能超过100 个字符")
	@ExcelAttribute(name = "开户行", maxLength = 100)
	@Schema(description = "开户行")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行")
	private String bankNameTwo;
	/**
	 * 卡号
	 */
	@Length(max = 50, message = "卡号 不能超过50 个字符")
	@ExcelAttribute(name = "卡号", maxLength = 50)
	@Schema(description = "卡号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("卡号")
	private String bankNoTwo;
	/**
	 * 抬头
	 */
	@Length(max = 50, message = "抬头 不能超过50 个字符")
	@ExcelAttribute(name = "抬头", maxLength = 50)
	@Schema(description = "抬头")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("抬头")
	private String titleTwo;
	/**
	 * 备注
	 */
	@Length(max = 255, message = "备注 不能超过255 个字符")
	@ExcelAttribute(name = "备注", maxLength = 255)
	@Schema(description = "备注")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备注")
	private String remarkTwo;

}
