/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 本期劳务费申报表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TStatisticsLaborVo extends RowIndex implements Serializable {

	/**
	 * ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "ID 不能为空")
	@Length(max = 32, message = "ID 不能超过32 个字符")
	@ExcelAttribute(name = "ID", isNotEmpty = true, errorInfo = "ID 不能为空", maxLength = 32)
	@Schema(description = "ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("ID")
	private String id;
	/**
	 * 申报单位
	 */
	@Length(max = 32, message = "申报单位 不能超过32 个字符")
	@ExcelAttribute(name = "申报单位", maxLength = 32)
	@Schema(description = "申报单位")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报单位")
	private String declareUnit;
	/**
	 * 申报月份（YYYYMM）
	 */
	@NotBlank(message = "申报月份（YYYYMM） 不能为空")
	@Length(max = 6, message = "申报月份（YYYYMM） 不能超过6 个字符")
	@ExcelAttribute(name = "申报月份（YYYYMM）", isNotEmpty = true, errorInfo = "申报月份（YYYYMM） 不能为空", maxLength = 6)
	@Schema(description = "申报月份（YYYYMM）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报月份（YYYYMM）")
	private String declareMonth;
	/**
	 * 员工姓名
	 */
	@Length(max = 32, message = "员工姓名 不能超过32 个字符")
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@Length(max = 32, message = "身份证号 不能超过32 个字符")
	@ExcelAttribute(name = "身份证号", maxLength = 32)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 证件类型
	 */
	@Length(max = 10, message = "证件类型 不能超过10 个字符")
	@ExcelAttribute(name = "证件类型", maxLength = 10)
	@Schema(description = "证件类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("证件类型")
	private String cardType;
	/**
	 * 收入
	 */
	@ExcelAttribute(name = "收入")
	@Schema(description = "收入")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收入")
	private BigDecimal income;
	/**
	 * 个税
	 */
	@ExcelAttribute(name = "个税")
	@Schema(description = "个税")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个税")
	private BigDecimal personalTax;
	/**
	 * 所得项目
	 */
	@Length(max = 20, message = "所得项目 不能超过20 个字符")
	@ExcelAttribute(name = "所得项目", maxLength = 20)
	@Schema(description = "所得项目")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所得项目")
	private String incomeItem;

}
