/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.SocialFundVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeAutoRegistCheckVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.vo.ListStringVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TInsuranceUnpurchasePersonCardVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.UpdateSocialFoundVo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialFundInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.*;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Set;

/**
 * 社保公积金查询表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
public interface TSocialFundInfoService extends IService<TSocialFundInfo> {
    /**
     * 社保公积金查询表简单分页查询
     * @param tSocialFundInfo 社保公积金查询表
     * @return
     */
    IPage<TSocialFundInfo> getTSocialFundInfoPage(Page<TSocialFundInfo> page, TSocialFundInfoSearchVo tSocialFundInfo);

	/**
	 * @param doMonth 执行月份
	 * @Description: 批量调基
	 * @Author: hgw
	 * @Date: 2022/7/22 11:32
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage>>
	 **/
	R<List<ErrorMessage>> importDiy(InputStream inputStream, String doMonth);

	/**
	 * @Description: 导出
	 * @Author: hgw
	 * @Date: 2022/7/26 16:45
	 * @return: void
	 **/
	void listExport(HttpServletResponse response, TSocialFundInfoSearchVo searchVo);

    List<TSocialFundInfo> noPageDiy(TSocialFundInfoSearchVo searchVo);

	DispatchOneDetailVo getTSocialFundInfoOne(TSocialFundInfoOneVo searchVo);

	/**
	 * @param id
	 * @Description: 社保公积金查询的详情
	 * @Author: hgw
	 * @Date: 2022/7/21 16:05
	 * @return: com.yifu.cloud.plus.v1.yifu.social.vo.TSocialFundInfoDetailVo
	 **/
	TSocialFundInfoDetailVo getDetailById(String id);

	void updateSocialAndFoundInfo(UpdateSocialFoundVo list);

	int selectSocialFoundByContract(TSocialFundInfo sf);

	Boolean selectExitSocialInjury(TInsuranceUnpurchasePersonCardVo cardVo);

	/**
	 * @Description:  获取在保的全量数据，定时任务处理不购买商险
	 * @Author: hgw
	 * @Date: 2025/1/15 16:28
	 * @return: com.yifu.cloud.plus.v1.yifu.salary.vo.ListStringVo
	 **/
	ListStringVo selectWorkInjuryHandleAll();

	SocialFundVo getSocialAndFundReduceListByEmpIdCardSet(Set<String> empIdCardSet);

	List<UnSocialFundInfoVo> selectUnSocialFundInfoByEmpIdcard(String empIdcard);

	Boolean selectExitEmpSocail(TEmployeeAutoRegistCheckVo cardVo);

}
