/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 人员档案表
 *
 * @author hgw
 * @date 2022-06-20 09:55:06
 */
@Data
@TableName("t_employee_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "人员档案表")
public class TEmployeeInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	/**
	 * 员工主码（系统自动生成：ZM+年月日+5位数字）
	 */
	@Schema(description = "员工主码（系统自动生成：ZM+年月日+5位数字）")
	private String empCode;

	/**
	 * 员工类型（字典值，0外包1派遣2代理3内部员工）
	 */
	@ExcelAttribute(name = "员工类型", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE)
	@Schema(description = "员工类型（字典值，0外包1派遣2代理3内部员工）")
	@NotNull(message = "员工类型不可为空")
	@Size(max = 1, message = "员工类型不可超过1位")
	private String empNatrue;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	@NotNull(message = "员工姓名不可为空")
	@Size(max = 20, message = "员工姓名不可超过20位")
	private String empName;

	/**
	 * 身份证号码
	 */
	@Schema(description = "身份证号码")
	@NotNull(message = "身份证号码不可为空")
	@Size(max = 20, message = "身份证号码不可超过20位")
	private String empIdcard;

	/**
	 * 身份证有效期起
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@Schema(description = "身份证有效期起")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date validityStart;

	/**
	 * 身份证有效期止
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@Schema(description = "身份证有效期止")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date validityEnd;

	/**
	 * 性别
	 */
	@Schema(description = "性别")
	private String empSex;

	/**
	 * 出生日期
	 * Error attempting to get column 'EMP_BIRTHDAY' from result set.  Cause: java.sql.SQLException: HOUR_OF_DAY
	 * 因为夏令时引起的。只有1940-06-03、1941-03-16、1986-05-04、1987-04-12、1988-04-10、1989-04-16、1990-04-15、1991-04-14几个时间会有如上错误抛出
	 * https://blog.csdn.net/weixin_51906670/article/details/130556793
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@Schema(description = "出生日期")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private java.sql.Date empBirthday;

	/**
	 * 年龄
	 */
	@Schema(description = "年龄")
	@Max(value = 200, message = "年龄不可超过200")
	private Integer empAge;

	/**
	 * 年龄查询开始
	 */
	@Schema(description = "年龄查询开始")
	@TableField(exist = false)
	private int empAgeStart;

	/**
	 * 年龄查询结束
	 */
	@Schema(description = "年龄查询结束")
	@TableField(exist = false)
	private int empAgeEnd;

	/**
	 * 婚姻状态
	 */
	@ExcelAttribute(name = "婚姻状态", isDataId = true, dataType = ExcelAttributeConstants.EMP_MARRIED)
	@Schema(description = "婚姻状态")
	private String empMarriStatus;

	/**
	 * 民族
	 */
	@Schema(description = "民族")
	private String empNational;

	/**
	 * 政治面貌
	 */
	@ExcelAttribute(name = "政治面貌", isDataId = true, dataType = ExcelAttributeConstants.POLITICAL_STATUS)
	@Schema(description = "政治面貌")
	@Size(max = 32, message = "政治面貌不可超过32位")
	private String politicalStatus;

	/**
	 * 邮箱
	 */
	@Schema(description = "邮箱")
	@Size(max = 50, message = "邮箱不可超过50位")
	private String empEmail;

	/**
	 * 手机号码
	 */
	@Schema(description = "手机号码")
	@NotNull(message = "手机号码不可为空")
	@Size(max = 11, min = 11, message = "手机号码只能11位")
	private String empPhone;

	/**
	 * 身份证-省
	 */
	@Schema(description = "身份证-省")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer idProvince;

	/**
	 * 身份证-市
	 */
	@Schema(description = "身份证-市")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer idCity;

	/**
	 * 身份证-县
	 */
	@Schema(description = "身份证-县")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer idTown;

	/**
	 * 户口性质
	 */
	@Schema(description = "户口性质")
	private String empRegisType;

	/**
	 * 档案-省
	 */
	@Schema(description = "档案-省")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer fileProvince;

	/**
	 * 档案-市
	 */
	@Schema(description = "档案-市")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer fileCity;

	/**
	 * 档案-县
	 */
	@Schema(description = "档案-县")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer fileTown;

	/**
	 * 是否大专及以上（0否1是）
	 */
	@Schema(description = "是否大专及以上（0否1是）")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer isCollege;

	/**
	 * 最高学历（字典值）
	 */
	@Schema(description = "最高学历（字典值）")
	private String hignEducation;

	/**
	 * 学校
	 */
	@Schema(description = "学校")
	private String school;

	/**
	 * 专业
	 */
	@Schema(description = "专业")
	private String major;

	/**
	 * 入学时间
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@Schema(description = "入学时间")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date admissionDate;

	/**
	 * 毕业时间
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@Schema(description = "毕业时间")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date gradutionDate;

	/**
	 * 备注
	 */
	@Schema(description = "备注")
	private String remark;

	/**
	 * 人员档案来源（字典：4人员档案新建、5项目档案新建、1社保/公积金、3商险、2薪酬、6电子签）
	 * 1=社保、公积金派单,2=人员发薪,3=商险派单,4=档案新建,5=批量导入,6=电子签,7：预入职,9瓜子
	 */
	@Schema(description = "人员档案来源（字典：1=社保、公积金派单,2=人员发薪,3=商险派单,4=档案新建,5=批量导入、6电子签,7：预入职,9瓜子）")
	private String fileSource;

	/**
	 * 人员档案状态（0草稿、1已审核）
	 */
	@Schema(description = "人员档案状态（0草稿、1已审核）")
	private Integer status;

	/**
	 * 档案状态（0正常；1已减档）
	 */
	@Schema(description = "档案状态（0正常；1已减档）")
	private Integer fileStatus;

	/**
	 * 现存项目数
	 */
	@Schema(description = "现存项目数")
	private Integer projectNum;

	/**
	 * 员工合同状态（字典:0初始1在用2不在用）
	 */
	@Schema(description = "员工合同状态（字典）0初始状态 personnel_state")
	@ExcelAttribute(name = "员工合同状态", isDataId = true, dataType = ExcelAttributeConstants.PERSONNEL_STATE)
	private Integer contractStatus;

	/**
	 * 商险状态（字典）
	 * 商险状态（字典0无2正常3失效4处理中）commercial_satte
	 */
	@Schema(description = "商险状态（字典）0初始状态")
	private Integer insuranceStatus;

	/**
	 * 社保公积金状态：#
	 *    1.社保状态派增（0待审核、1待办理、2办理中 3办理成功、4部分办理失败 5 办理失败 10 审核不通过）、派减（6待审核 7待办理 8办理成功 9 办理失败 ）
	 *    2.公积金状态：派增（0待审核、1待办理、3办理成功、4办理失败9 审核不通过）、派减（5待审核 6待办理 7 办理成功 8 办理失败 ）
	 * 社保状态（字典）
	 * 	1、派单处社保或公积金状态为待审核、待办理、办理中，项目档案处社保或公积金状态为处理中；           0，1,2  = 1
	 * 	2、派单处社保或公积金状态为审核不通过或办理失败，项目档案处社保状态为无社保，公积金状态为无公积金； 10,5=0
	 * 	3、派单处社保状态为部分办理失败，项目档案处社保状态为部分购买                                4=2
	 * 	4、派单处社保或公积金状态为办理成功，项目档案处社保或公积金状态为正常                          3=3
	 * 	派减：
	 * 	1、派减状态为待审核、待办理、审核不通过、办理失败，项目档案处社保或公积金状态不变；              6,7,9 = 3
	 * 	2、派减状态为办理成功，项目档案处社保或公积金状态变为已派减                                  8=4
	 * 	人员档案处社保或公积金状态根据身份证+项目进行整合：
	 * 	社保状态优先级：正常>部分购买>处理中>已派减>无社保
	 * 	公积金状态优先级：正常>处理中>已派减>无公积金
	 */
	@Schema(description = "社保状态（字典）0初始状态： 0 无社保 1 处理中 2.部分购买 3.正常 4.已派减")
	private Integer socialStatus;

	/**
	 * 社保公积金状态：#
	 *    1.社保状态派增（0待审核、1待办理、2办理中 3办理成功、4部分办理失败 5 办理失败 10 审核不通过）、派减（6待审核 7待办理 8办理成功 9 办理失败 ）
	 *    2.公积金状态：派增（0待审核、1待办理、3办理成功、4办理失败9 审核不通过）、派减（5待审核 6待办理 7 办理成功 8 办理失败 ）
	 * 社保状态（字典）
	 * 	1、派单处社保或公积金状态为待审核、待办理、办理中，项目档案处社保或公积金状态为处理中；           0,1=1
	 * 	2、派单处社保或公积金状态为审核不通过或办理失败，项目档案处社保状态为无社保，公积金状态为无公积金； 9,4=0
	 * 	3、派单处社保状态为部分办理失败，项目档案处社保状态为部分购买
	 * 	4、派单处社保或公积金状态为办理成功，项目档案处社保或公积金状态为正常                          3=3
	 * 	派减：
	 * 	1、派减状态为待审核、待办理、审核不通过、办理失败，项目档案处社保或公积金状态不变；             5,6,8 =3
	 * 	2、派减状态为办理成功，项目档案处社保或公积金状态变为已派减                                7=4
	 * 	人员档案处社保或公积金状态根据身份证+项目进行整合：
	 * 	社保状态优先级：正常>部分购买>处理中>已派减>无社保
	 * 	公积金状态优先级：正常>处理中>已派减>无公积金
	 * 公积金状态（字典）0初始状态
	 */
	@Schema(description = "公积金状态（字典）0初始状态：0 无公积金 1 处理中 2.部分购买 3.正常 4.已派减")
	private Integer fundStatus;

	/**
	 * 近3个月发薪（0无；1是；2否）
	 */
	@Schema(description = "近3个月发薪（0无；1是；2否）")
	private Integer salaryStatus;

	/**
	 * 是否删除 0否/1是
	 */
	@Schema(description = "是否删除 0否/1是")
	private String deleteFlag;

	/**
	 * 减档操作人id
	 */
	@Schema(description = "减档操作人id")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String leaveUser;
	/**
	 * 减档操作人姓名
	 */
	@Schema(description = "减档人")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String leaveUserName;

	/**
	 * 离职时间
	 */
	@Schema(description = "减档时间")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date leaveTime;

	/**
	 * 离职原因
	 */
	@Schema(description = "减档原因")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String leaveReason;

	/**
	 * 离职备注
	 */
	@Schema(description = "减档备注")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String leaveRemark;

	/**
	 * 通信地址
	 */
	@Schema(description = "通信地址")
	private String contactAddress;

	// 以下是项目档案信息
	@TableField(exist = false)
	@Schema(description = "单位名称")
	private String unitName;

	@TableField(exist = false)
	@Schema(description = "单位编码")
	private String unitNo;

	@TableField(exist = false)
	@Schema(description = "项目id")
	private String deptId;

	@TableField(exist = false)
	@Schema(description = "项目名称")
	private String deptName;

	@TableField(exist = false)
	@Schema(description = "项目编码")
	private String deptNo;

	@TableField(exist = false)
	@Schema(description = "就职岗位")
	private String post;

	@TableField(exist = false)
	@Schema(description = "选中的idList")
	private List<String> idList;

	@TableField(exist = false)
	@Schema(description = "导出的表头的Set")
	private Set<String> exportFields;

	@Schema(description = "减档时间起")
	@TableField(exist = false)
	private String leaveTimeStart;

	@Schema(description = "减档时间止")
	@TableField(exist = false)
	private String leaveTimeEnd;

	/**
	 * 开户行总行
	 */
	@ExcelAttribute(name = "开户行总行", maxLength = 50)
	@Length(max = 50, message = "开户行总行不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行总行")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String bankName;
	/**
	 * 开户行省
	 */
	@ExcelAttribute(name = "开户行省",isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行省")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String bankProvince;
	/**
	 * 开户行市
	 */
	@ExcelAttribute(name = "开户行市",isArea = true,parentField = "bankProvince")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行市")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String bankCity;
	/**
	 * 开户行支行
	 */
	@ExcelAttribute(name = "开户行支行", maxLength = 50)
	@Length(max = 50, message = "开户行支行不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行支行")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String bankSubName;
	/**
	 * 银行卡号
	 */
	@ExcelAttribute(name = "银行卡号", maxLength = 50)
	@Length(max = 50, message = "银行卡号不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("银行卡号")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String bankNo;
	/**
	 * 计税月份
	 */
	@ExcelAttribute(name = "计税月份", maxLength = 6)
	@Length(max = 6, message = "计税月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("计税月份")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String taxMonth;
	/**
	 * 通信地址省
	 */
	@ExcelAttribute(name = "通信地址省",isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("通信地址省")
	private String contactProvince;
	/**
	 * 通信地址市
	 */
	@ExcelAttribute(name = "通信地址市",isArea = true,parentField = "contactProvince")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("通信地址市")
	private String contactCity;
	/**
	 * 通信地址县
	 */
	@ExcelAttribute(name = "通信地址县",isArea = true,parentField = "contactCity")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("通信地址县")
	private String contactTown;
	/**
	 * 封面抬头
	 */
	@ExcelAttribute(name = "封面抬头", maxLength = 50)
	@Length(max = 50, message = "封面抬头不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("封面抬头")
	private String invoiceTitle;

	@Schema(description = "社保状态多个")
	@TableField(exist = false)
	private String[] socialStatusArray;
	@Schema(description = "公积金状态多个")
	@TableField(exist = false)
	private String[] fundStatusArray;
	@Schema(description = "商险状态多个")
	@TableField(exist = false)
	private String[] insuranceStatusArray;
	@Schema(description = "合同状态多个")
	@TableField(exist = false)
	private String[] contractStatusArray;
	@Schema(description = "员工类型多个")
	@TableField(exist = false)
	private String[] empNatureArray;

	@Schema(description = "姓名或身份证")
	@TableField(exist = false)
	private String nameOrIdcard;

	//开始时间（查询专用）
	@Schema(description =  "创建开始时间")
	@TableField(exist = false)
	private LocalDateTime createTimeStart;
	//截止时间（查询专用）
	@Schema(description =  "创建截止时间")
	@TableField(exist = false)
	private LocalDateTime createTimeEnd;

	/**
	 * 是否为首份工作 0是/1否
	 */
	@Schema(description ="是否为首份工作 0是/1否")
	private String firstWorkFlag;
	/**
	 * 是否有职业资格证书:0 是  1 否
	 */
	@ExcelAttribute(name = "是否有职业资格证书",isNotEmpty = true,isDataId = true, readConverterExp = "0=是,1=否")
	@Schema(description ="是否有职业资格证书:0 是  1 否")
	private String haveQualification;

	/**
	 * 其他附件--C段二维码扫码数据
	 */
	@TableField(exist = false)
	private List<TEmpOtherFile> otherFiles;

	// 员工声明
	@TableField(exist = false)
	private TPreEmpDeclaration tPreEmpDeclaration;

	// 档案编辑的其他附件之外的附件，例如：身份证正反面，户口本2页、员工声明、员工确认
	@TableField(exist = false)
	private List<TAttaInfo> attaList;

	// 档案编辑的其他附件之外的附件，例如：身份证正反面，户口本2页、员工声明、员工确认
	// 身份证9\24
	@TableField(exist = false)
	private TAttaInfo attaIdCardOne;
	@TableField(exist = false)
	private TAttaInfo attaIdCardTwo;
	// 户口本10\25
	@TableField(exist = false)
	private TAttaInfo attaRegistrationOne;
	@TableField(exist = false)
	private TAttaInfo attaRegistrationTwo;
	// 员工声明21\25
	@TableField(exist = false)
	private TAttaInfo attaDeclearOne;
	@TableField(exist = false)
	private TAttaInfo attaDeclearTwo;

}
