/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import lombok.Data;

import java.io.Serializable;

/**
 * 瓜子档案表——导出家庭成员
 *
 * @author hgw
 * @date 2025-6-19 15:35:34
 */
@Data
@ColumnWidth(15)
public class TGzEmpInfoExportFamily implements Serializable {

	// 流程ID	姓名	证件号码	与成员关系	姓名	联系电话	地址	所在单位名称	是否客户单位任职	职务
	@ExcelProperty("流程ID")
	private String bizId;
	@ExcelProperty("姓名")
	private String name;
	@ExcelProperty("证件号码")
	private String nationalId;

	@ExcelAttribute(name = "与成员关系", isDataId = true, dataType = ExcelAttributeConstants.GZ_FAMILY_RELATION)
	@ExcelProperty("与成员关系")
	private String familyRelation;
	@ExcelProperty("姓名")
	private String familyName;
	@ExcelProperty("联系电话")
	private String familyPhone;
	@ExcelProperty("地址")
	private String familyAddress;
	@ExcelProperty("所在单位名称")
	private String familyCompany;
	@ExcelAttribute(name = "是否客户单位任职", isDataId = true, readConverterExp = "Y=是,N=不是")
	@ExcelProperty("是否客户单位任职")
	private String gzEmeFlag;
	@ExcelProperty("职务")
	private String jobCode;

}
