/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzEmpInfo;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TGzEmpInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TGzContractService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;

/**
 * 瓜子合同提取方法
 *
 * @author hgw
 * @date 2025-6-23 11:15:28
 */
@Log4j2
@Service
@RequiredArgsConstructor
public class TGzContractServiceImpl implements TGzContractService {

	private final TGzEmpInfoMapper tGzEmpInfoMapper;

	/**
	 * 生成瓜子档案里的合同信息
	 * chenyx
	 *
	 * @param contractInfo 合同信息
	 * @param offerId      offerId
	 * @param workLocation 工作地点
	 */
	@Override
	public void saveContractInfoToGzEmpInfo(TEmployeeContractInfo contractInfo, Integer offerId, String workLocation) {
		// 获取档案信息
		TGzEmpInfo gzEmpInfo = tGzEmpInfoMapper.getInfoByOfferId(offerId);
		if (Common.isNotNull(gzEmpInfo)) {
			gzEmpInfo.setContractNum(contractInfo.getContractName());
			// 客服申请处选择“标准合同”传“外签-劳动合同 ”；“实习协议”传“外签-实习协议 ”
			if (CommonConstants.ONE_STRING.equals(contractInfo.getContractType())) {
				gzEmpInfo.setContractType("1E");
			}
			if (CommonConstants.FIVE_STRING.equals(contractInfo.getContractType())) {
				gzEmpInfo.setContractType("1F");
			}
			gzEmpInfo.setSginatureMethod("E");
			gzEmpInfo.setSginatureType("01");
			gzEmpInfo.setSginatureDt(contractInfo.getContractStart());
			gzEmpInfo.setContractBeginDt(contractInfo.getContractStart());
			gzEmpInfo.setContractExpEndDt(contractInfo.getContractEnd());
			gzEmpInfo.setContractEndDt(contractInfo.getContractEnd());
			// 合同申请处选择“无”传给瓜子为“0”；合同申请选择“六个月”，传给瓜子为“6”
			if ("无".equals(contractInfo.getTryPeriod())) {
				gzEmpInfo.setProbation(CommonConstants.ZERO_STRING);
			}
			if ("六个月".equals(contractInfo.getTryPeriod())) {
				gzEmpInfo.setProbation(CommonConstants.SIX_STRING);
				// 按照“合同起始日期”及“试用周期”进行推测
				// 合同起始日期为20250603，试用期为6，试用期预计结束日期为20251202

				// 将Date转换为LocalDate
				LocalDate localDate = contractInfo.getContractStart().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
				LocalDate prcExpLocalDate = localDate.plusMonths(6); // 加上6个月
				// 将LocalDate转换回Date对象
				Date prcExpDt = Date.from(prcExpLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
				// 试用期预计结束日期
				gzEmpInfo.setPrcExpDt(prcExpDt);

				// 默认等于试用期预计结束日期+1日（自然日），eg：”试用期预计结束日期“为20251202，”预计转正日期“为20251203“
				LocalDate probationDtLocalDate = prcExpLocalDate.plusDays(1); // 加上+1日（自然日）
				// 将LocalDate转换回Date对象
				Date probationDt = Date.from(probationDtLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
				// 预计转正日期
				gzEmpInfo.setProbationDt(probationDt);
			}

			gzEmpInfo.setNeeProviderId(CommonConstants.GZ_NEE_PROVIDER_ID);
			gzEmpInfo.setWorkLocation(workLocation);
			gzEmpInfo.setContractState("A");

			// 存合同信息
			tGzEmpInfoMapper.updateById(gzEmpInfo);
		}
	}

}
