package com.yifu.cloud.plus.v1.business.entity.system;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;


/**
 * B端标签表
 *
 * @author hgw
 * @date 2021-08-11 17:00:52
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_bus_lable")
@Schema(description = "B端标签表")
public class TBusLable extends Model<TBusLable> {
     private static final long serialVersionUID = 1L;
     /**
      * 主键
      */
     @TableId(type = IdType.AUTO)
     @Schema(description = "主键")
     private Integer id;
     /**
      * 标签名称
      */
     @Length(max = 100, message = "标签名称不能超过100个字符")
     @ExcelAttribute(name = "标签名称", maxLength = 100)
     @Schema(description = "标签名称")
     private String name;
     /**
      * 说明
      */
     @Length(max = 200, message = "说明不能超过200个字符")
     @ExcelAttribute(name = "说明", maxLength = 200)
     @Schema(description = "说明")
     private String remark;
     /**
      * 是否启用，0启用,1禁用
      */
     @ExcelAttribute(name = "是否启用，0启用,1禁用")
     @Schema(description = "是否启用，0启用,1禁用")
     private Integer status;
     /**
      * 创建人id
      */
     @NotBlank(message = "创建人id不能为空")
     @Length(max = 32, message = "创建人id不能超过32个字符")
     @ExcelAttribute(name = "创建人id", isNotEmpty = true, errorInfo = "创建人id不能为空", maxLength = 32)
     @Schema(description = "创建人id")
     private String createUserId;
     /**
      * 创建人姓名
      */
     @Length(max = 50, message = "创建人姓名不能超过50个字符")
     @ExcelAttribute(name = "创建人姓名", maxLength = 50)
     @Schema(description = "创建人姓名")
     private String createUserName;
     /**
      * 创建时间
      */
	 @JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	 @DateTimeFormat( pattern = "yyyy-MM-dd HH:mm:ss")
     @ExcelAttribute(name = "创建时间")
     @Schema(description = "创建时间")
     private LocalDateTime createTime;
     /**
      * 删除标志，0未删除
      */
     @ExcelAttribute(name = "删除标志，0未删除")
     @Schema(description = "删除标志，0未删除")
     private Integer deleteFlag;
}
