/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 最低工资提醒-每月更新一次
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class SysMessageSalaryVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
	private String id;
	/**
	 * 实发工资
	 */
	@NotBlank(message = "实发工资 不能为空")
	@ExcelAttribute(name = "实发工资", isNotEmpty = true, errorInfo = "实发工资 不能为空")
	@Schema(description = "实发工资")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("实发工资")
	private BigDecimal actualSalary;
	/**
	 * 最低工资标准
	 */
	@ExcelAttribute(name = "最低工资标准")
	@Schema(description = "最低工资标准")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最低工资标准")
	private BigDecimal salaryBase;
	/**
	 * 工资月
	 */
	@Length(max = 10, message = "工资月 不能超过10 个字符")
	@ExcelAttribute(name = "工资月", maxLength = 10)
	@Schema(description = "工资月")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资月")
	private String salaryMonth;
	/**
	 * 结算月
	 */
	@Length(max = 10, message = "结算月 不能超过10 个字符")
	@ExcelAttribute(name = "结算月", maxLength = 10)
	@Schema(description = "结算月")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算月")
	private String settleMonth;
	/**
	 * 员工信息
	 */
	@Length(max = 32, message = "员工信息 不能超过32 个字符")
	@ExcelAttribute(name = "员工信息", maxLength = 32)
	@Schema(description = "员工信息")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工信息")
	private String employeeId;
	/**
	 * employeeName
	 */
	@Length(max = 50, message = "employeeName 不能超过50 个字符")
	@ExcelAttribute(name = "employeeName", maxLength = 50)
	@Schema(description = "employeeName")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("employeeName")
	private String employeeName;
	/**
	 * employeeIdnum
	 */
	@Length(max = 50, message = "employeeIdnum 不能超过50 个字符")
	@ExcelAttribute(name = "employeeIdnum", maxLength = 50)
	@Schema(description = "employeeIdnum")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("employeeIdnum")
	private String employeeIdnum;
	/**
	 * 工资制表人
	 */
	@Length(max = 32, message = "工资制表人 不能超过32 个字符")
	@ExcelAttribute(name = "工资制表人", maxLength = 32)
	@Schema(description = "工资制表人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资制表人")
	private String salaryMakeMan;
	/**
	 * 省
	 */
	@ExcelAttribute(name = "省")
	@Schema(description = "省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("省")
	private Integer province;
	/**
	 * 市
	 */
	@ExcelAttribute(name = "市")
	@Schema(description = "市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("市")
	private Integer city;
	/**
	 * 县
	 */
	@ExcelAttribute(name = "县")
	@Schema(description = "县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("县")
	private Integer town;
	/**
	 * 部门ID
	 */
	@NotBlank(message = "部门ID 不能为空")
	@Length(max = 32, message = "部门ID 不能超过32 个字符")
	@ExcelAttribute(name = "部门ID", isNotEmpty = true, errorInfo = "部门ID 不能为空", maxLength = 32)
	@Schema(description = "部门ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门ID")
	private String departId;
	/**
	 * 部门名称
	 */
	@NotBlank(message = "部门名称 不能为空")
	@Length(max = 50, message = "部门名称 不能超过50 个字符")
	@ExcelAttribute(name = "部门名称", isNotEmpty = true, errorInfo = "部门名称 不能为空", maxLength = 50)
	@Schema(description = "部门名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门名称")
	private String departName;
	/**
	 * 部门编码
	 */
	@Length(max = 50, message = "部门编码 不能超过50 个字符")
	@ExcelAttribute(name = "部门编码", maxLength = 50)
	@Schema(description = "部门编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门编码")
	private String departNo;
	/**
	 * 类型0：工资；1：工程工资
	 */
	@ExcelAttribute(name = "类型0：工资；1：工程工资")
	@Schema(description = "类型0：工资；1：工程工资")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型0：工资；1：工程工资")
	private Integer type;
	/**
	 * 应发工资
	 */
	@ExcelAttribute(name = "应发工资")
	@Schema(description = "应发工资")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("应发工资")
	private BigDecimal relaySalary;
	/**
	 * 反馈
	 */
	@Length(max = 300, message = "反馈 不能超过300 个字符")
	@ExcelAttribute(name = "反馈", maxLength = 300)
	@Schema(description = "反馈")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("反馈")
	private String feedback;
	/**
	 * 有忽略提醒 0：忽略 1：不忽略
	 */
	@Length(max = 1, message = "有忽略提醒 0：忽略 1：不忽略 不能超过1 个字符")
	@ExcelAttribute(name = "有忽略提醒 0：忽略 1：不忽略", maxLength = 1)
	@Schema(description = "有忽略提醒 0：忽略 1：不忽略")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("有忽略提醒 0：忽略 1：不忽略")
	private String ignoreFlag;
	/**
	 * 客户id
	 */
	@Length(max = 32, message = "客户id 不能超过32 个字符")
	@ExcelAttribute(name = "客户id", maxLength = 32)
	@Schema(description = "客户id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户id")
	private String customerId;
	/**
	 * 客户名称
	 */
	@NotBlank(message = "客户名称 不能为空")
	@Length(max = 50, message = "客户名称 不能超过50 个字符")
	@ExcelAttribute(name = "客户名称", isNotEmpty = true, errorInfo = "客户名称 不能为空", maxLength = 50)
	@Schema(description = "客户名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String customerName;

}
