package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardSetDetail;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryStandardSetDetailService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;


/**
 * 薪资工资条配置明细表
 *
 * @author hgw
 * @date 2021-10-08 14:36:56
 */
@RestController
@AllArgsConstructor
@RequestMapping("/tsalarystandardsetdetail")
@Tag(name = "薪资工资条配置明细表")
public class TSalaryStandardSetDetailController {

     private final TSalaryStandardSetDetailService tSalaryStandardSetDetailService;

     /**
      * 简单分页查询
      *
      * @param page                     分页对象
      * @param tSalaryStandardSetDetail 薪资工资条配置明细表
      * @return
      */
     @Operation(description = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TSalaryStandardSetDetail>> getTSalaryStandardSetDetailPage(Page<TSalaryStandardSetDetail> page, TSalaryStandardSetDetail tSalaryStandardSetDetail) {
          return new R<>(tSalaryStandardSetDetailService.getTSalaryStandardSetDetailPage(page, tSalaryStandardSetDetail));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
     @Operation(description = "id查询")
     @GetMapping("/{id}")
     public R<TSalaryStandardSetDetail> getById(@PathVariable("id") String id) {
          return new R<>(tSalaryStandardSetDetailService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tSalaryStandardSetDetail
      * @return R
      */
     @Operation(description = "新增(wxhr:tsalarystandardsetdetail_add)")
     @PostMapping
     @PreAuthorize("@pms.hasPermission('wxhr:tsalarystandardsetdetail_add')")
     public R<Boolean> save(@Valid @RequestBody TSalaryStandardSetDetail tSalaryStandardSetDetail) {
          return new R<>(tSalaryStandardSetDetailService.save(tSalaryStandardSetDetail));
     }

     /**
      * 修改记录
      *
      * @param tSalaryStandardSetDetail
      * @return R
      */
     @Operation(description = "修改(wxhr:tsalarystandardsetdetail_edit)")
     @SysLog("修改薪资工资条配置明细表")
     @PutMapping
     @PreAuthorize("@pms.hasPermission('wxhr:tsalarystandardsetdetail_edit')")
     public R<Boolean> update(@RequestBody TSalaryStandardSetDetail tSalaryStandardSetDetail) {
          return new R<>(tSalaryStandardSetDetailService.updateById(tSalaryStandardSetDetail));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
     @Operation(description = "删除(wxhr:tsalarystandardsetdetail_del)")
     @SysLog("删除薪资工资条配置明细表")
     @DeleteMapping("/{id}")
     @PreAuthorize("@pms.hasPermission('wxhr:tsalarystandardsetdetail_del')")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tSalaryStandardSetDetailService.removeById(id));
     }

}
