/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsCurrentReport;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryStandardExportVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryStandardSearchVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TStatisticsCurrentReportSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 统计-本期申报
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Mapper
public interface TStatisticsCurrentReportMapper extends BaseMapper<TStatisticsCurrentReport> {
    /**
     * 统计-本期申报简单分页查询
     * @param tStatisticsCurrentReport 统计-本期申报
     * @return
     */
    IPage<TStatisticsCurrentReport> getTStatisticsCurrentReportPage(Page<TStatisticsCurrentReport> page, @Param("tStatisticsCurrentReport") TStatisticsCurrentReport tStatisticsCurrentReport);

	int insertStatisticsCurrentReport(@Param("declareMonth") String declareMonth
			, @Param("lastMonth") String lastMonth, @Param("lastTwoMonth") String lastTwoMonth
			, @Param("lastTwoYear") String lastTwoYear);

	/**
	 * @param yearMonth
	 * @Description: 删除-按申报月份
	 * @Author: hgw
	 * @Date: 2020/6/16 15:19
	 * @return: int
	 **/
	int deleteByYearMonth(@Param("yearMonth") String yearMonth);

	/**
	 * @Description: 导出
	 * @Author: hgw
	 * @Date: 2023/1/16 17:44
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsCurrentReport>
	 **/
	List<TStatisticsCurrentReport> getCurrentReportExport(@Param("tStatisticsCurrentReport") TStatisticsCurrentReportSearchVo tStatisticsCurrentReport, @Param("idList")List<String> idList);

}
