/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.salary.entity.MSalaryEstimate;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.MSalaryEstimateMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.MSalaryEstimateService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.MSalaryEstimateSearchVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

/**
 * 工资表-缴费库
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Log4j2
@Service
public class MSalaryEstimateServiceImpl extends ServiceImpl<MSalaryEstimateMapper, MSalaryEstimate> implements MSalaryEstimateService {
	/**
	 * 工资表-缴费库简单分页查询
	 *
	 * @param mSalaryEstimate 工资表-缴费库
	 * @return
	 */
	@Override
	public IPage<MSalaryEstimate> getMSalaryEstimatePage(Page<MSalaryEstimate> page, MSalaryEstimateSearchVo mSalaryEstimate) {
		return baseMapper.getMSalaryEstimatePage(page, mSalaryEstimate);
	}


}
