package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class TPaymentAllInfoVo implements Serializable {

    private String id;
    /**
     * 员工姓名
     */
    @Length(max = 20, message = "员工姓名不能超过20个字符")
    @ExcelAttribute(name = "员工姓名", maxLength = 20)
    @Schema(description = "员工姓名", name = "empName")
    private String empName;
    /**
     * 员工编码
     */
    @Length(max = 32, message = "员工编码不能超过32个字符")
    @ExcelAttribute(name = "员工编码",  maxLength = 32)
    @Schema(description = "员工编码", name = "empNo")
    private String empNo;
    /**
     * 员工ID
     */
    @Length(max = 32, message = "员工ID不能超过32个字符")
    @ExcelAttribute(name = "员工ID", maxLength = 32)
    @Schema(description = "员工ID", name = "empId")
    private String empId;
    /**
     * 员工身份证
     */
    @Length(max = 100, message = "不能超过100个字符")
    @ExcelAttribute(name = "身份证号", isNotEmpty = true, maxLength = 100,errorInfo = "身份证字段不可为空！")
    @Schema(description = "身份证号", name = "empIdcard")
    private String empIdcard;
    /**
     * 单位名称
     */
    @Length(max = 50, message = "单位名称不能超过50个字符")
    @ExcelAttribute(name = "单位名称",  maxLength = 50, isDataId = true, dataType = ExcelAttributeConstants.CUSTOMER)
    @Schema(description = "单位名称", name = "unitId")
    private String unitId;
    /**
     * 部门名称
     */
    @Length(max = 50, message = "部门名称不能超过50个字符")
    @ExcelAttribute(name = "部门名称",  maxLength = 50, isDataId = true, dataType = ExcelAttributeConstants.DEPART)
    @Schema(description = "部门名称", name = "settleDomainId")
    private String settleDomainId;
    /**
     * 社保户(dataType 要与导出的字段数据对应上)
     */
    @Length(max = 32, message = "社保户不能超过32个字符")
    @ExcelAttribute(name = "社保户", maxLength = 32, isDataId = true,dataType = ExcelAttributeConstants.HOUSEHOLD)
    @Schema(description = "社保户", name = "socialHousehold")
    private String socialHousehold;
    /**
     * 社保编号
     */
    @Length(max = 20, message = "社保编号不能超过20个字符")
    @ExcelAttribute(name = "社保编号", maxLength = 20)
    @Schema(description = "社保编号", name = "socialSecurityNo")
    private String socialSecurityNo;
    /**
     * 社保缴纳地
     */
    @Length(max = 50, message = "社保缴纳地不能超过50个字符")
    @ExcelAttribute(name = "社保缴纳地",  maxLength = 50)
    @Schema(description = "社保缴纳地", name = "socialPayAddr")
    private String socialPayAddr;

    /**
     * 社保缴纳地-省
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "社保缴纳地-省",  maxLength = 32, isDataId = true, isArea = true)
    @Schema(description = "社保缴纳地-省", name = "fileProvince")
    private Integer socialProvince;
    /**
     * 社保缴纳地-市
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "社保缴纳地-市",  maxLength = 32, isDataId = true, isArea = true, parentField = "socialProvince")
    @Schema(description = "社保缴纳地-市", name = "fileCity")
    private Integer socialCity;
    /**
     * 社保缴纳地-县
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "社保缴纳地-县",  maxLength = 32, isDataId = true, isArea = true, parentField = "socialCity")
    @Schema(description = "社保缴纳地-县", name = "fileTown")
    private Integer socialTown;
    /**
     * 社保缴纳月份empNo
     */
    @Length(max = 6, message = "社保缴纳月份不能超过6个字符")
    @ExcelAttribute(name = "社保缴纳月份", maxLength = 6)
    @Schema(description = "社保缴纳月份", name = "socialPayMonth")
    private String socialPayMonth;
    /**
     * 社保生成月份
     */
    @Length(max = 6, message = "社保生成月份不能超过6个字符")
    @ExcelAttribute(name = "社保生成月份",  maxLength = 6)
    @Schema(description = "社保生成月份", name = "socialCreateMonth")
    private String socialCreateMonth;
    /**
     * 创建人
     */
    @Length(max = 32, message = "创建人不能超过32个字符")
    @ExcelAttribute(name = "创建人", maxLength = 32)
    @Schema(description = "创建人", name = "createUser")
    private String createUser;
    /**
     * 最后更新人
     */
    @Length(max = 32, message = "最后更新人不能超过32个字符")
    @ExcelAttribute(name = "最后更新人", maxLength = 32)
    @Schema(description = "最后更新人", name = "lastUpdateUser")
    private String lastUpdateUser;
    /**
     * 最后更新时间
     */
    @ExcelAttribute(name = "最后更新时间")
    @Schema(description = "最后更新时间", name = "lastUpdateTime")
    private LocalDateTime lastUpdateTime;
    /**
     * 锁定状态 0 未锁定 1 锁定
     */
    @Length(max = 1, message = "锁定状态 0 未锁定 1 锁定不能超过1个字符")
    @ExcelAttribute(name = "锁定状态 0 未锁定 1 锁定", maxLength = 1)
    @Schema(description = "锁定状态 0 未锁定 1 锁定", name = "lockStatus")
    private String lockStatus;
    /**
     * 结算状态  0: 未结算  1: 待结算  2: 已结算
     */
    @Length(max = 1, message = "结算状态  0: 未结算  1: 待结算  2: 已结算不能超过1个字符")
    @ExcelAttribute(name = "结算状态", maxLength = 1,isDataId = true,dataType = "settlement_flag")
    @Schema(description = "结算状态  0: 未结算  1: 待结算  2: 已结算", name = "settlementFlag")
    private String settlementFlag;
    /**
     * 公积金缴纳月份
     */
    @Length(max = 6, message = "公积金缴纳月份不能超过6个字符")
    @ExcelAttribute(name = "公积金缴纳月份",  maxLength = 6)
    @Schema(description = "公积金缴纳月份", name = "providentPayMonth")
    private String providentPayMonth;
    /**
     * 公积金生成月份
     */
    @Length(max = 6, message = "公积金生成月份不能超过6个字符")
    @ExcelAttribute(name = "公积金生成月份",  maxLength = 6)
    @Schema(description = "公积金生成月份", name = "providentCreateMonth")
    private String providentCreateMonth;
    /**
     * 公积金户
     */
    @Length(max = 32, message = "公积金户不能超过32个字符")
    @ExcelAttribute(name = "公积金户", maxLength = 32,isDataId = true,dataType = ExcelAttributeConstants.HOUSEHOLD)
    @Schema(description = "公积金户", name = "providentHousehold")
    private String providentHousehold;
    /**
     * 公积金缴纳地
     */
    @Length(max = 50, message = "公积金缴纳地不能超过50个字符")
    @ExcelAttribute(name = "公积金缴纳地",  maxLength = 50)
    @Schema(description = "公积金缴纳地", name = "providentPayAddr")
    private String providentPayAddr;

    /**
     *  缴纳地-省
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "公积金缴纳地-省",  maxLength = 32, isDataId = true, isArea = true)
    @Schema(description = "公积金缴纳地-省", name = "fundProvince")
    private Integer fundProvince;
    /**
     *  缴纳地-市
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "公积金缴纳地-市",  maxLength = 32, isDataId = true, isArea = true, parentField = "fundProvince")
    @Schema(description = "公积金缴纳地-市", name = "fundCity")
    private Integer fundCity;
    /**
     *  缴纳地-县
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "公积金缴纳地-县", maxLength = 32, isDataId = true, isArea = true, parentField = "fundlCity")
    @Schema(description = "公积金缴纳地-县", name = "fundTown")
    private Integer fundTown;

    /**
     *  社保ID
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "社保ID", maxLength = 32, isDataId = true)
    @Schema(description = "社保ID", name = "socialId")
    private String socialId;

    /**
     *  公积金ID
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "公积金ID", maxLength = 32, isDataId = true)
    @Schema(description = "公积金ID", name = "fundId")
    private String fundId;

    /**
     * 社保合计
     */
    @ExcelAttribute(name = "社保合计")
    @Schema(description = "社保合计", name = "socialSum")
    private BigDecimal socialSum;
    /**
     * 单位社保合计
     */
    @ExcelAttribute(name = "单位社保合计")
    @Schema(description = "单位社保合计", name = "unitSocialSum")
    private BigDecimal unitSocialSum;
    /**
     * 个人社保合计
     */
    @ExcelAttribute(name = "个人社保合计")
    @Schema(description = "个人社保合计", name = "socialSecurityPersonalSum")
    private BigDecimal socialSecurityPersonalSum;

    /**
     * 公积金总合计
     */
    @ExcelAttribute(name = "公积金总合计")
    @Schema(description = "公积金总合计", name = "providentSum")
    private BigDecimal providentSum;
    /**
     * 总合计
     */
    @ExcelAttribute(name = "总合计")
    @Schema(description = "总合计", name = "sumAll")
    private BigDecimal sumAll;
    /**
     * 创建时间
     */
    @ExcelAttribute(name = "创建时间")
    @Schema(description = "创建时间", name = "createTime")
    private LocalDateTime createTime;
    /**
     * 就职班组
     */
    @Length(max = 50, message = "就职班组不能超过50个字符")
    @ExcelAttribute(name = "就职班组", maxLength = 50)
    @Schema(description = "就职班组", name = "inauguralTeam")
    private String inauguralTeam;
    /**
     * 电信编号
     */
    @Length(max = 50, message = "电信编号不能超过50个字符")
    @ExcelAttribute(name = "电信编号", maxLength = 50)
    @Schema(description = "电信编号", name = "telecomNumber")
    private String telecomNumber;
    /***************************社保明细**************************/
    /**
     * 单位社保补缴利息
     */
    @ExcelAttribute(name = "单位补缴利息")
    @Schema(description = "单位补缴利息", name = "companyAccrual")
    private BigDecimal companyAccrual;
    /**
     * 个人社保补缴利息
     */
    @ExcelAttribute(name = "个人补缴利息")
    @Schema(description = "个人补缴利息", name = "personalAccrual")
    private BigDecimal personalAccrual;
    /**
     * 单位养老基数
     */
    @ExcelAttribute(name = "养老基数")
    @Schema(description = "养老基数", name = "unitPensionSet")
    private BigDecimal unitPensionSet;
    /**
     * 单位医疗基数
     */
    @ExcelAttribute(name = "医保基数")
    @Schema(description = "医保基数", name = "unitMedicalSet")
    private BigDecimal unitMedicalSet;
    /**
     * 单位失业基数
     */
    @ExcelAttribute(name = "失业基数")
    @Schema(description = "失业基数", name = "unitUnemploymentSet")
    private BigDecimal unitUnemploymentSet;
    /**
     * 单位工伤基数
     */
    @ExcelAttribute(name = "工伤基数")
    @Schema(description = "工伤基数", name = "unitInjurySet")
    private BigDecimal unitInjurySet;
    /**
     * 单位生育基数
     */
    @ExcelAttribute(name = "生育基数")
    @Schema(description = "生育基数", name = "unitBirthSet")
    private BigDecimal unitBirthSet;
    /**
     * 个人养老基数
     */
    @ExcelAttribute(name = "个人养老基数")
    @Schema(description = "个人养老基数", name = "personalPensionSet")
    private BigDecimal personalPensionSet;
    /**
     * 个人医疗基数
     */
    @ExcelAttribute(name = "个人医疗基数")
    @Schema(description = "个人医疗基数", name = "personalMedicalSet")
    private BigDecimal personalMedicalSet;
    /**
     * 个人失业基数
     */
    @ExcelAttribute(name = "个人失业基数")
    @Schema(description = "个人失业基数", name = "personalUnemploymentSet")
    private BigDecimal personalUnemploymentSet;
    /**
     * 单位养老比例
     */
    @ExcelAttribute(name = "单位养老比例")
    @Schema(description = "单位养老比例", name = "unitPensionPer")
    private BigDecimal unitPensionPer;
    /**
     * 单位医疗比例
     */
    @ExcelAttribute(name = "单位医疗比例")
    @Schema(description = "单位医疗比例", name = "unitMedicalPer")
    private BigDecimal unitMedicalPer;
    /**
     * 单位失业比例
     */
    @ExcelAttribute(name = "单位失业比例")
    @Schema(description = "单位失业比例", name = "unitUnemploymentPer")
    private BigDecimal unitUnemploymentPer;
    /**
     * 单位工伤比例
     */
    @ExcelAttribute(name = "单位工伤比例")
    @Schema(description = "单位工伤比例", name = "unitInjuryPer")
    private BigDecimal unitInjuryPer;
    /**
     * 单位生育比例
     */
    @ExcelAttribute(name = "单位生育比例")
    @Schema(description = "单位生育比例", name = "unitBirthPer")
    private BigDecimal unitBirthPer;
    /**
     * 个人养老比例
     */
    @ExcelAttribute(name = "个人养老比例")
    @Schema(description = "个人养老比例", name = "personalPensionPer")
    private BigDecimal personalPensionPer;
    /**
     * 个人医疗比例
     */
    @ExcelAttribute(name = "个人医疗比例")
    @Schema(description = "个人医疗比例", name = "personalMedicalPer")
    private BigDecimal personalMedicalPer;
    /**
     * 个人失业比例
     */
    @ExcelAttribute(name = "个人失业比例")
    @Schema(description = "个人失业比例", name = "personalUnemploymentPer")
    private BigDecimal personalUnemploymentPer;
    /**
     * 单位大病比例
     */
    @ExcelAttribute(name = "单位大病比例")
    @Schema(description = "单位大病比例", name = "unitBigailmentPer")
    private BigDecimal unitBigailmentPer;
    /**
     * 个人大病比例
     */
    @ExcelAttribute(name = "个人大病比例")
    @Schema(description = "个人大病比例", name = "personalBigailmentPer")
    private BigDecimal personalBigailmentPer;
    /**
     * 单位养老金额
     */
    @ExcelAttribute(name = "养老单位缴费")
    @Schema(description = "养老单位缴费", name = "unitPensionMoney")
    private BigDecimal unitPensionMoney;
    /**
     * 单位医疗金额
     */
    @ExcelAttribute(name = "医保单位缴费")
    @Schema(description = "医保单位缴费", name = "unitMedicalMoney")
    private BigDecimal unitMedicalMoney;
    /**
     * 单位失业金额
     */
    @ExcelAttribute(name = "失业单位缴费")
    @Schema(description = "失业单位缴费", name = "unitUnemploymentMoney")
    private BigDecimal unitUnemploymentMoney;
    /**
     * 单位工伤金额
     */
    @ExcelAttribute(name = "工伤缴费")
    @Schema(description = "工伤缴费", name = "unitInjuryMoney")
    private BigDecimal unitInjuryMoney;
    /**
     * 单位生育金额
     */
    @ExcelAttribute(name = "生育缴费")
    @Schema(description = "生育缴费", name = "unitBirthMoney")
    private BigDecimal unitBirthMoney;
    /**
     * 单位大病金额
     */
    @ExcelAttribute(name = "单位医疗救助金")
    @Schema(description = "单位医疗救助金", name = "unitBigmailmentMoney")
    private BigDecimal unitBigmailmentMoney;
    /**
     * 个人养老金额
     */
    @ExcelAttribute(name = "养老个人缴费")
    @Schema(description = "养老个人缴费", name = "personalPensionMoney")
    private BigDecimal personalPensionMoney;
    /**
     * 个人医疗金额
     */
    @ExcelAttribute(name = "医保个人缴费")
    @Schema(description = "医保个人缴费", name = "personalMedicalMoney")
    private BigDecimal personalMedicalMoney;
    /**
     * 个人失业金额
     */
    @ExcelAttribute(name = "失业个人缴费")
    @Schema(description = "失业个人缴费", name = "personalUnemploymentMoney")
    private BigDecimal personalUnemploymentMoney;
    /**
     * 个人大病金额
     */
    @ExcelAttribute(name = "个人医疗救助金")
    @Schema(description = "个人医疗救助金", name = "personalBigmailmentMoney")
    private BigDecimal personalBigmailmentMoney;
    /************************公积金明细***************************/
    /**
     * 公积金编号
     */
    @Length(max = 50, message = "公积金编号不能超过50个字符")
    @ExcelAttribute(name = "公积金编号", maxLength = 50)
    @Schema(description = "公积金编号", name = "providentNo")
    private String providentNo;
    /**
     * 单位公积金基数
     */
    @ExcelAttribute(name = "公积金单边基数")
    @Schema(description = "公积金单边基数", name = "unitProvidentSet")
    private BigDecimal unitProvidentSet;
    /**
     * 单边公积金比例
     */
    @ExcelAttribute(name = "公积金单边比例")
    @Schema(description = "公积金单边比例", name = "providentPercent")
    private BigDecimal providentPercent;
    /**
     * 单位公积金费用
     */
    @ExcelAttribute(name = "公积金单边金额")
    @Schema(description = "公积金单边金额", name = "unitProvidentSum")
    private BigDecimal unitProvidentSum;
    /**
     * 个人公积金基数
     */
    @ExcelAttribute(name = "个人公积金基数")
    @Schema(description = "个人公积金基数", name = "personalProidentSet")
    private BigDecimal personalProidentSet;
    /**
     * 个人公积金费用
     */
    @ExcelAttribute(name = "个人公积金费用")
    @Schema(description = "个人公积金费用", name = "personalProvidentSum")
    private BigDecimal personalProvidentSum;

    /**
     * 社保结算状态  0: 未结算  1: 待结算  2: 已结算
     */
    @ExcelAttribute(name = "社保结算状态", maxLength = 1,isDataId = true,dataType = "settlement_flag")
    @Schema(description = "社保结算状态  0: 未结算  1: 待结算  2: 已结算", name = "socialSettlementFlag")
    private String socialSettlementFlag;

    /**
     * 公积金结算状态  0: 未结算  1: 待结算  2: 已结算
     */
    @ExcelAttribute(name = "公积金结算状态", maxLength = 1,isDataId = true,dataType = "settlement_flag")
    @Schema(description = "公积金结算状态  0: 未结算  1: 待结算  2: 已结算", name = "fundSettlementFlag")
    private String fundSettlementFlag;

    /**
     * 社保核准表ID
     */
    @ExcelAttribute(name = "社保核准表ID", maxLength = 32)
    @Schema(description = "社保核准表ID", name = "socialSettlementId")
    private String socialSettlementId;

    /**
     * 公积金核准表ID
     */
    @ExcelAttribute(name = "公积金核准表ID", maxLength = 32)
    @Schema(description = "公积金核准表ID", name = "fundSettlementId")
    private String fundSettlementId;

    /**
     * 工资社保结算状态  0: 未结算  1: 待结算  2: 已结算
     */
    @Length(max = 1, message = "工资社保结算状态  0: 未结算  1: 已结算不能超过1个字符")
    @ExcelAttribute(name = "工资社保结算状态", maxLength = 1,isDataId = true,dataType = "settlement_flag")
    @Schema(description = "工资社保结算状态  0: 未结算  1: 已结算", name = "salarySocialFlag")
    private String salarySocialFlag;
    /**
     * 工资公积金结算状态  0: 未结算  1: 待结算  2: 已结算
     */
    @Length(max = 1, message = "工资公积金结算状态  0: 未结算  1: 已结算不能超过1个字符")
    @ExcelAttribute(name = "工资公积金结算状态", maxLength = 1,isDataId = true,dataType = "settlement_flag")
    @Schema(description = "工资公积金结算状态  0: 未结算  1: 已结算", name = "salaryFundFlag")
    private String salaryFundFlag;

}
