/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 社保士兵列表查询
 *
 * @author hgw
 * @date 2024-5-13 15:36:27
 */
@Data
public class TSocialSoldierPageVo extends TDispatchInfo {

	/**
	 * 社保户名称
	 */
	@ExcelAttribute(name = "社保户名称", maxLength = 50)
	@Schema(description = "社保户名称" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户名称" )
	private String socialHouseholdName;

	@NotBlank(message = "养工失状态不能为空" )
	@Length(max = 32, message = "养工失状态 不能超过32个字符" )
	@ExcelAttribute(name = "养工失状态", isNotEmpty = true, errorInfo = "办理状态不能为空", maxLength = 32)
	@Schema(description = "养工失状态：（0空、1待办理、2自动办理中、3继续办理、4终止办理、5人工处理、6成功）" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养工失状态" )
	private String ygsHandleStatus;
	/**
	 * 医生大状态：（0空、1待办理、2自动办理中、3继续办理、4终止办理、5人工处理）
	 */
	@NotBlank(message = "医生大状态不能为空" )
	@Length(max = 32, message = "医生大状态 不能超过32个字符" )
	@ExcelAttribute(name = "医生大状态", isNotEmpty = true, errorInfo = "办理状态不能为空", maxLength = 32)
	@Schema(description = "医生大状态：（0空、1待办理、2自动办理中、3继续办理、4终止办理、5人工处理、6成功）" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医生大状态" )
	private String ysdHandleStatus;
	/**
	 * 养工失反馈
	 */
	@Length(max = 500, message = "养工失反馈 不能超过500个字符" )
	@ExcelAttribute(name = "养工失反馈", maxLength = 500)
	@Schema(description = "养工失反馈" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养工失反馈" )
	private String ygsRemark;
	/**
	 * 医生大反馈
	 */
	@Length(max = 500, message = "医生大反馈 不能超过500个字符" )
	@ExcelAttribute(name = "医生大反馈", maxLength = 500)
	@Schema(description = "医生大反馈" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医生大反馈" )
	private String ysdRemark;
	/**
	 * 养工失反馈-原反馈
	 */
	@Length(max = 500, message = "养工失反馈-原反馈 不能超过500个字符" )
	@ExcelAttribute(name = "养工失反馈-原反馈", maxLength = 500)
	@Schema(description = "养工失反馈-原反馈" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养工失反馈-原反馈" )
	private String ygsRemarkOld;
	/**
	 * 医生大反馈-原反馈
	 */
	@Length(max = 500, message = "医生大反馈-原反馈 不能超过500个字符" )
	@ExcelAttribute(name = "医生大反馈-原反馈", maxLength = 500)
	@Schema(description = "医生大反馈-原反馈" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医生大反馈-原反馈" )
	private String ysdRemarkOld;

	@Length(max = 50, message = "社保请求ID 不能超过50个字符" )
	@ExcelAttribute(name = "社保请求ID", maxLength = 50)
	@Schema(description = "社保请求ID" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保请求ID" )
	private String ygsRequestId;

	@Length(max = 50, message = "医保请求ID 不能超过50个字符" )
	@ExcelAttribute(name = "医保请求ID", maxLength = 50)
	@Schema(description = "医保请求ID" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医保请求ID" )
	private String ysdRequestId;

}
