package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.social.entity.FailReasonConfig;
import com.yifu.cloud.plus.v1.yifu.social.mapper.FailReasonConfigMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.FailReasonConfigService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 失败原因配置
 *
 * @author huyc
 * @date 2024-05-08 10:41:32
 */
@Log4j2
@Service
public class FailReasonConfigServiceImpl extends ServiceImpl<FailReasonConfigMapper, FailReasonConfig> implements FailReasonConfigService {
	/**
	 * 失败原因配置简单分页查询
	 * @param failReasonConfig 失败原因配置
	 * @return
	 */
	@Override
	public IPage<FailReasonConfig> getFailReasonConfigPage(Page<FailReasonConfig> page, FailReasonConfig failReasonConfig){
		return baseMapper.getFailReasonConfigPage(page,failReasonConfig);
	}

	/**
	 * @Description: 获取list组装map来使用 hgw
	 * @Author: hgw
	 * @Date: 2024/5/11 16:23
	 * @return: java.util.Map<java.lang.String, com.yifu.cloud.plus.v1.yifu.social.entity.FailReasonConfig>
	 **/
	@Override
	public Map<String, FailReasonConfig> getFailReasonMap() {
		Map<String, FailReasonConfig> map = new HashMap<>();
		List<FailReasonConfig> list = baseMapper.getFailReasonConfigList();
		for (FailReasonConfig config : list) {
			map.put(config.getReasonKey(), config);
		}
		return map;
	}

}