/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.admin.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysOutEmpCategorizeFormInfo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.SysOutEmpCategorizeFormInfoVo;
import com.yifu.cloud.plus.v1.yifu.admin.mapper.SysOutEmpCategorizeFormInfoMapper;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysOutEmpCategorizeFormInfoService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;


/**
 * 瓜子采集表单信息分类表
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
@Log4j2
@Service
public class SysOutEmpCategorizeFormInfoServiceImpl extends ServiceImpl<SysOutEmpCategorizeFormInfoMapper, SysOutEmpCategorizeFormInfo> implements SysOutEmpCategorizeFormInfoService {
	/**
	 * 瓜子采集表单信息分类表简单分页查询
	 *
	 * @param sysOutEmpCategorizeFormInfo 瓜子采集表单信息分类表
	 * @return
	 */
	@Override
	public IPage<SysOutEmpCategorizeFormInfo> getSysOutEmpCategorizeFormInfoPage(Page<SysOutEmpCategorizeFormInfo> page, SysOutEmpCategorizeFormInfo sysOutEmpCategorizeFormInfo) {
		return baseMapper.getSysOutEmpCategorizeFormInfoPage(page, sysOutEmpCategorizeFormInfo);
	}

	@Override
	public List<SysOutEmpCategorizeFormInfoVo> getCategorizeVoList(String isLookToc) {
		return baseMapper.getCategorizeVoList(isLookToc);
	}
}
